<?php

namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class SupportController extends Controller
{
    public function announcements()
    {
        $announcements = \App\Models\Announcement::where('published', true)
                                                 ->latest('published_at')
                                                 ->paginate(20);
        
        return view('client.support.announcements', compact('announcements'));
    }

    public function knowledgebase()
    {
        $categories = \App\Models\KnowledgebaseCategory::withCount('articles')
                                                        ->orderBy('order')
                                                        ->get();
        
        return view('client.support.knowledgebase', compact('categories'));
    }

    public function downloads()
    {
        $downloads = \App\Models\Download::where('published', true)
                                         ->orderBy('category')
                                         ->orderBy('name')
                                         ->get();
        
        return view('client.support.downloads', compact('downloads'));
    }

    public function networkStatus()
    {
        $servers = \App\Models\Server::orderBy('name')->get();
        
        $incidents = \App\Models\NetworkIssue::whereIn('status', ['open', 'scheduled'])
                                              ->latest('created_at')
                                              ->get();
        
        return view('client.support.network-status', compact('servers', 'incidents'));
    }
}
