<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DomainPricing extends Model
{
    use HasFactory;

    protected $table = 'domain_pricing';

    protected $fillable = [
        'extension',
        'register_price',
        'renew_price',
        'transfer_price',
        'active',
    ];

    protected function casts(): array
    {
        return [
            'register_price' => 'decimal:2',
            'renew_price' => 'decimal:2',
            'transfer_price' => 'decimal:2',
            'active' => 'boolean',
        ];
    }
}
