<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PaymentGateway extends Model
{
    protected $fillable = [
        'name',
        'slug',
        'display_name',
        'description',
        'is_active',
        'is_test_mode',
        'config',
        'supported_currencies',
        'transaction_fee_percentage',
        'transaction_fee_fixed',
        'display_order',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'is_test_mode' => 'boolean',
        'config' => 'array',
        'supported_currencies' => 'array',
        'transaction_fee_percentage' => 'decimal:2',
        'transaction_fee_fixed' => 'decimal:2',
    ];

    public function transactions()
    {
        return $this->hasMany(Transaction::class, 'gateway', 'slug');
    }

    public function getConfigValue($key, $default = null)
    {
        return $this->config[$key] ?? $default;
    }

    public function setConfigValue($key, $value)
    {
        $config = $this->config ?? [];
        $config[$key] = $value;
        $this->config = $config;
        $this->save();
    }
}
