<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Server extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'hostname',
        'ip_address',
        'type',
        'username',
        'password',
        'port',
        'secure',
        'active',
        'max_accounts',
        'accounts_count',
        'nameserver1',
        'nameserver2',
        'nameserver3',
        'nameserver4',
        'notes',
    ];

    protected $hidden = [
        'password',
    ];

    protected function casts(): array
    {
        return [
            'secure' => 'boolean',
            'active' => 'boolean',
            'port' => 'integer',
            'max_accounts' => 'integer',
            'accounts_count' => 'integer',
        ];
    }

    public function products()
    {
        return $this->hasMany(Product::class);
    }

    public function isAvailable(): bool
    {
        if (!$this->active) {
            return false;
        }

        if ($this->max_accounts > 0 && $this->accounts_count >= $this->max_accounts) {
            return false;
        }

        return true;
    }

    public function getConnectionUrl(): string
    {
        $protocol = $this->secure ? 'https' : 'http';
        return "{$protocol}://{$this->hostname}:{$this->port}";
    }
}
