<?php

namespace App\Services;

use Illuminate\Support\Facades\File;

class TemplateService
{
    public function getActiveTemplate()
    {
        return setting('active_template', config('app.default_theme'));
    }

    public function getTemplates()
    {
        $templatesPath = resource_path('views/templates');
        
        if (!File::exists($templatesPath)) {
            return [];
        }

        $directories = File::directories($templatesPath);
        $templates = [];

        foreach ($directories as $directory) {
            $name = basename($directory);
            $templates[] = [
                'name' => $name,
                'path' => $directory,
            ];
        }

        return $templates;
    }

    public function setActiveTemplate($templateName)
    {
        $templates = $this->getTemplates();
        $templateNames = array_column($templates, 'name');

        if (in_array($templateName, $templateNames)) {
            \App\Models\Setting::set('active_template', $templateName);
            return true;
        }

        return false;
    }
}
