<?php

namespace App\View\Composers;

use Illuminate\View\View;
use Illuminate\Support\Facades\Cache;
use App\Models\Setting;

class SettingsComposer
{
    /**
     * Bind data to the view.
     *
     * @param  \Illuminate\View\View  $view
     * @return void
     */
    public function compose(View $view)
    {
        // Cache settings for 1 hour to avoid database queries on every request
        $settings = Cache::remember('site_settings', 3600, function () {
            return [
                'site_name' => Setting::get('site_name', config('app.name')),
                'site_logo' => Setting::get('site_logo'),
                'site_email' => Setting::get('site_email'),
                'site_address' => Setting::get('site_address'),
            ];
        });

        $view->with('siteSettings', $settings);
    }
}
