<?php

return [
    'paths' => [
        'modules' => base_path('app/Modules'),
        'payment_gateways' => base_path('app/Modules/PaymentGateways'),
        'templates' => resource_path('views/templates'),
    ],
    'currencies' => [
        'USD' => ['symbol' => '$', 'name' => 'US Dollar'],
        'EUR' => ['symbol' => '€', 'name' => 'Euro'],
        'GBP' => ['symbol' => '£', 'name' => 'British Pound'],
        'JPY' => ['symbol' => '¥', 'name' => 'Japanese Yen'],
    ],
    'payment_gateways' => [
        'paypal' => [
            'name' => 'PayPal',
            'class' => 'App\\Modules\\PaymentGateways\\PayPal\\PayPalGateway',
            'enabled' => true,
        ],
    ],
    'invoice' => [
        'prefix' => 'INV-',
        'due_days' => 30,
    ],
    'ticket' => [
        'statuses' => ['open', 'pending', 'answered', 'closed'],
        'priorities' => ['low', 'medium', 'high', 'urgent'],
    ],
];
