<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description')->nullable();
            $table->enum('type', ['hosting', 'domain', 'vps', 'dedicated'])->default('hosting');
            $table->boolean('active')->default(true);
            $table->foreignId('server_id')->nullable()->constrained()->onDelete('set null');
            $table->json('features')->nullable(); // Disk, Bandwidth, Email accounts, etc.
            $table->timestamps();
        });

        Schema::create('product_pricing', function (Blueprint $table) {
            $table->id();
            $table->foreignId('product_id')->constrained()->onDelete('cascade');
            $table->enum('billing_cycle', ['monthly', 'quarterly', 'semi-annually', 'annually', 'biennially', 'triennially']);
            $table->decimal('price', 10, 2);
            $table->decimal('setup_fee', 10, 2)->default(0);
            $table->timestamps();
        });

        Schema::create('domain_pricing', function (Blueprint $table) {
            $table->id();
            $table->string('extension'); // .com, .net, .org, etc.
            $table->decimal('register_price', 10, 2);
            $table->decimal('renew_price', 10, 2);
            $table->decimal('transfer_price', 10, 2);
            $table->boolean('active')->default(true);
            $table->timestamps();
        });

        Schema::create('domain_registrars', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('api_url')->nullable();
            $table->string('api_key')->nullable();
            $table->string('api_secret')->nullable();
            $table->boolean('active')->default(false);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('product_pricing');
        Schema::dropIfExists('products');
        Schema::dropIfExists('domain_pricing');
        Schema::dropIfExists('domain_registrars');
    }
};
