@extends('layouts.app')

@section('title', 'Admin Dashboard')

@section('content')
<div class="min-h-screen bg-gray-900">
    <!-- Mega Menu Navigation (Already in layouts.app) -->
    
    <!-- Main Content Area with Sidebar -->
    <div class="flex">
        <!-- Sidebar for Quick Actions -->
        <aside class="hidden lg:block w-64 bg-gray-800 border-r border-gray-700 min-h-screen" x-data="{ shortcuts: true }">
            <div class="p-6">
                <h2 class="text-sm font-semibold text-gray-400 uppercase tracking-wider mb-4">Quick Actions</h2>
                <nav class="space-y-2">
                    <a href="{{ route('admin.users.index') }}" class="flex items-center px-3 py-2 text-sm text-gray-300 hover:bg-gray-700 rounded-lg transition">
                        <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"></path>
                        </svg>
                        Manage Clients
                    </a>
                    <a href="{{ route('admin.services.index') }}" class="flex items-center px-3 py-2 text-sm text-gray-300 hover:bg-gray-700 rounded-lg transition">
                        <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 12h14M5 12a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v4a2 2 0 01-2 2M5 12a2 2 0 00-2 2v4a2 2 0 002 2h14a2 2 0 002-2v-4a2 2 0 00-2-2m-2-4h.01M17 16h.01"></path>
                        </svg>
                        View Services
                    </a>
                    <a href="{{ route('admin.invoices.index') }}" class="flex items-center px-3 py-2 text-sm text-gray-300 hover:bg-gray-700 rounded-lg transition">
                        <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                        View Invoices
                    </a>
                    <a href="{{ route('admin.tickets.index') }}" class="flex items-center px-3 py-2 text-sm text-gray-300 hover:bg-gray-700 rounded-lg transition">
                        <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z"></path>
                        </svg>
                        Support Tickets
                    </a>
                    <a href="{{ route('admin.settings.index') }}" class="flex items-center px-3 py-2 text-sm text-gray-300 hover:bg-gray-700 rounded-lg transition">
                        <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        </svg>
                        System Settings
                    </a>
                </nav>

                <div class="mt-8 pt-6 border-t border-gray-700">
                    <h3 class="text-xs font-semibold text-gray-400 uppercase tracking-wider mb-3">System Status</h3>
                    <div class="space-y-2">
                        <div class="flex items-center justify-between text-xs">
                            <span class="text-gray-400">Database</span>
                            <span class="flex items-center text-green-400">
                                <span class="w-2 h-2 bg-green-400 rounded-full mr-1"></span>
                                Online
                            </span>
                        </div>
                        <div class="flex items-center justify-between text-xs">
                            <span class="text-gray-400">Mail Server</span>
                            <span class="flex items-center text-green-400">
                                <span class="w-2 h-2 bg-green-400 rounded-full mr-1"></span>
                                Online
                            </span>
                        </div>
                        <div class="flex items-center justify-between text-xs">
                            <span class="text-gray-400">Cron Jobs</span>
                            <span class="flex items-center text-green-400">
                                <span class="w-2 h-2 bg-green-400 rounded-full mr-1"></span>
                                Running
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </aside>

        <!-- Main Content -->
        <main class="flex-1 p-6 lg:p-8">
            <div class="max-w-7xl mx-auto">
                <!-- Header -->
                <div class="mb-8">
                    <h1 class="text-3xl font-bold text-white mb-2">Admin Dashboard</h1>
                    <p class="text-gray-400">Welcome back! Here's what's happening with your business today.</p>
                </div>

                <!-- Key Stats Grid -->
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
                    <!-- Revenue Today -->
                    <div class="bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl p-6 shadow-lg">
                        <div class="flex items-center justify-between mb-4">
                            <div class="p-3 bg-white/20 rounded-lg">
                                <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                            </div>
                            <span class="text-xs font-semibold text-blue-100 bg-white/20 px-2 py-1 rounded-full">Today</span>
                        </div>
                        <h3 class="text-sm font-medium text-blue-100 mb-1">Revenue</h3>
                        <p class="text-3xl font-bold text-white">{{ '$' . number_format($stats['revenue_today'], 2) }}</p>
                    </div>

                    <!-- Total Users -->
                    <div class="bg-gray-800 border border-gray-700 rounded-xl p-6 shadow-lg hover:border-purple-500 transition">
                        <div class="flex items-center justify-between mb-4">
                            <div class="p-3 bg-purple-500/10 rounded-lg">
                                <svg class="w-6 h-6 text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"></path>
                                </svg>
                            </div>
                        </div>
                        <h3 class="text-sm font-medium text-gray-400 mb-1">Total Clients</h3>
                        <p class="text-3xl font-bold text-white">{{ number_format($stats['total_users']) }}</p>
                    </div>

                    <!-- Active Services -->
                    <div class="bg-gray-800 border border-gray-700 rounded-xl p-6 shadow-lg hover:border-green-500 transition">
                        <div class="flex items-center justify-between mb-4">
                            <div class="p-3 bg-green-500/10 rounded-lg">
                                <svg class="w-6 h-6 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 12h14M5 12a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v4a2 2 0 01-2 2M5 12a2 2 0 00-2 2v4a2 2 0 002 2h14a2 2 0 002-2v-4a2 2 0 00-2-2m-2-4h.01M17 16h.01"></path>
                                </svg>
                            </div>
                        </div>
                        <h3 class="text-sm font-medium text-gray-400 mb-1">Active Services</h3>
                        <p class="text-3xl font-bold text-white">{{ number_format($stats['active_services']) }}</p>
                    </div>

                    <!-- Open Tickets -->
                    <div class="bg-gray-800 border border-gray-700 rounded-xl p-6 shadow-lg hover:border-yellow-500 transition">
                        <div class="flex items-center justify-between mb-4">
                            <div class="p-3 bg-yellow-500/10 rounded-lg">
                                <svg class="w-6 h-6 text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z"></path>
                                </svg>
                            </div>
                        </div>
                        <h3 class="text-sm font-medium text-gray-400 mb-1">Open Tickets</h3>
                        <p class="text-3xl font-bold text-white">{{ number_format($stats['open_tickets']) }}</p>
                    </div>
                </div>

                <!-- Secondary Stats -->
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
                    <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                        <div class="flex items-center justify-between">
                            <div>
                                <h3 class="text-sm font-medium text-gray-400 mb-1">Revenue This Month</h3>
                                <p class="text-2xl font-bold text-green-400">{{ '$' . number_format($stats['revenue_this_month'], 2) }}</p>
                            </div>
                            <div class="p-3 bg-green-500/10 rounded-lg">
                                <svg class="w-8 h-8 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path>
                                </svg>
                            </div>
                        </div>
                    </div>

                    <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                        <div class="flex items-center justify-between">
                            <div>
                                <h3 class="text-sm font-medium text-gray-400 mb-1">Pending Orders</h3>
                                <p class="text-2xl font-bold text-orange-400">{{ number_format($stats['pending_orders']) }}</p>
                            </div>
                            <div class="p-3 bg-orange-500/10 rounded-lg">
                                <svg class="w-8 h-8 text-orange-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                            </div>
                        </div>
                    </div>

                    <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                        <div class="flex items-center justify-between">
                            <div>
                                <h3 class="text-sm font-medium text-gray-400 mb-1">Cancellations (Month)</h3>
                                <p class="text-2xl font-bold text-red-400">{{ number_format($stats['cancelled_services']) }}</p>
                            </div>
                            <div class="p-3 bg-red-500/10 rounded-lg">
                                <svg class="w-8 h-8 text-red-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                                </svg>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Activity and Details -->
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-8">
                    <!-- Activity Feed -->
                    <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                        <div class="flex items-center justify-between mb-6">
                            <h2 class="text-lg font-semibold text-white">Recent Activity</h2>
                            <a href="#" class="text-sm text-blue-400 hover:text-blue-300">View All</a>
                        </div>
                        <div class="space-y-4">
                            @foreach($recent_users->take(3) as $user)
                            <div class="flex items-start space-x-3 p-3 hover:bg-gray-700/50 rounded-lg transition">
                                <div class="flex-shrink-0">
                                    <div class="w-10 h-10 bg-gradient-to-r from-blue-500 to-purple-600 rounded-full flex items-center justify-center">
                                        <span class="text-white font-semibold text-sm">{{ substr($user->name, 0, 1) }}</span>
                                    </div>
                                </div>
                                <div class="flex-1 min-w-0">
                                    <p class="text-sm text-gray-300">
                                        <span class="font-medium text-white">{{ $user->name }}</span> registered a new account
                                    </p>
                                    <p class="text-xs text-gray-500">{{ $user->created_at->diffForHumans() }}</p>
                                </div>
                            </div>
                            @endforeach
                            @foreach($recent_services->take(2) as $service)
                            <div class="flex items-start space-x-3 p-3 hover:bg-gray-700/50 rounded-lg transition">
                                <div class="flex-shrink-0">
                                    <div class="w-10 h-10 bg-green-500/20 rounded-full flex items-center justify-center">
                                        <svg class="w-5 h-5 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                                        </svg>
                                    </div>
                                </div>
                                <div class="flex-1 min-w-0">
                                    <p class="text-sm text-gray-300">
                                        New service order from <span class="font-medium text-white">{{ $service->user->name ?? 'Unknown' }}</span>
                                    </p>
                                    <p class="text-xs text-gray-500">{{ $service->created_at->diffForHumans() }}</p>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>

                    <!-- Support Overview -->
                    <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                        <div class="flex items-center justify-between mb-6">
                            <h2 class="text-lg font-semibold text-white">Support Status</h2>
                            <a href="{{ route('admin.tickets.index') }}" class="text-sm text-blue-400 hover:text-blue-300">View All</a>
                        </div>
                        <div class="space-y-4">
                            @forelse($recent_tickets as $ticket)
                            <div class="flex items-start space-x-3 p-3 hover:bg-gray-700/50 rounded-lg transition">
                                <div class="flex-shrink-0">
                                    <div class="w-10 h-10 bg-yellow-500/20 rounded-full flex items-center justify-center">
                                        <svg class="w-5 h-5 text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z"></path>
                                        </svg>
                                    </div>
                                </div>
                                <div class="flex-1 min-w-0">
                                    <p class="text-sm font-medium text-white truncate">{{ $ticket->subject }}</p>
                                    <p class="text-xs text-gray-400">{{ $ticket->user->name ?? 'Unknown' }} • {{ $ticket->created_at->diffForHumans() }}</p>
                                    <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium {{ $ticket->status === 'open' ? 'bg-yellow-500/10 text-yellow-400' : 'bg-green-500/10 text-green-400' }} mt-1">
                                        {{ ucfirst($ticket->status) }}
                                    </span>
                                </div>
                            </div>
                            @empty
                            <div class="text-center py-8">
                                <svg class="w-12 h-12 text-gray-600 mx-auto mb-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                <p class="text-gray-400 text-sm">No open tickets</p>
                            </div>
                            @endforelse
                        </div>
                    </div>
                </div>

                <!-- Recent Tables -->
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                    <!-- Recent Clients -->
                    <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                        <div class="flex items-center justify-between mb-6">
                            <h2 class="text-lg font-semibold text-white">Recent Clients</h2>
                            <a href="{{ route('admin.users.index') }}" class="text-sm text-blue-400 hover:text-blue-300">View All</a>
                        </div>
                        <div class="overflow-x-auto">
                            <table class="w-full">
                                <thead>
                                    <tr class="text-left text-xs text-gray-400 border-b border-gray-700">
                                        <th class="pb-3 font-medium">Name</th>
                                        <th class="pb-3 font-medium">Email</th>
                                        <th class="pb-3 font-medium">Joined</th>
                                    </tr>
                                </thead>
                                <tbody class="text-sm">
                                    @foreach($recent_users as $user)
                                    <tr class="border-b border-gray-700/50 hover:bg-gray-700/30 transition">
                                        <td class="py-3 text-gray-300">{{ $user->name }}</td>
                                        <td class="py-3 text-gray-400">{{ $user->email }}</td>
                                        <td class="py-3 text-gray-500">{{ $user->created_at->format('M d, Y') }}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- Recent Invoices -->
                    <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                        <div class="flex items-center justify-between mb-6">
                            <h2 class="text-lg font-semibold text-white">Recent Invoices</h2>
                            <a href="{{ route('admin.invoices.index') }}" class="text-sm text-blue-400 hover:text-blue-300">View All</a>
                        </div>
                        <div class="overflow-x-auto">
                            <table class="w-full">
                                <thead>
                                    <tr class="text-left text-xs text-gray-400 border-b border-gray-700">
                                        <th class="pb-3 font-medium">Invoice #</th>
                                        <th class="pb-3 font-medium">Client</th>
                                        <th class="pb-3 font-medium">Amount</th>
                                        <th class="pb-3 font-medium">Status</th>
                                    </tr>
                                </thead>
                                <tbody class="text-sm">
                                    @foreach($recent_invoices as $invoice)
                                    <tr class="border-b border-gray-700/50 hover:bg-gray-700/30 transition">
                                        <td class="py-3 text-gray-300">{{ $invoice->invoice_number }}</td>
                                        <td class="py-3 text-gray-400">{{ $invoice->user->name ?? 'N/A' }}</td>
                                        <td class="py-3 text-gray-300">{{ format_currency($invoice->total) }}</td>
                                        <td class="py-3">
                                            <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium {{ $invoice->status === 'paid' ? 'bg-green-500/10 text-green-400' : ($invoice->status === 'unpaid' ? 'bg-yellow-500/10 text-yellow-400' : 'bg-red-500/10 text-red-400') }}">
                                                {{ ucfirst($invoice->status) }}
                                            </span>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>
@endsection
