@extends('layouts.app')
@section('title', 'Domain Pricing')
@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-3xl font-bold text-white">Domain Pricing</h1>
        <a href="{{ route('admin.domain-pricing.create') }}" class="px-4 py-2 bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700 text-white font-semibold rounded-lg transition shadow-lg">
            Add Domain TLD
        </a>
    </div>

    @if(session('success'))
        <div class="mb-4 p-4 bg-green-900 border border-green-700 text-green-300 rounded-lg">
            {{ session('success') }}
        </div>
    @endif

    <div class="bg-gray-800 shadow rounded-lg border border-gray-700 overflow-hidden">
        <table class="min-w-full divide-y divide-gray-700">
            <thead class="bg-gray-900">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase">Extension</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase">Register</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase">Renew</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase">Transfer</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase">Actions</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-700">
                @forelse($domainPricing as $pricing)
                <tr class="hover:bg-gray-700">
                    <td class="px-6 py-4 whitespace-nowrap">
                        <span class="text-lg font-bold text-blue-400">{{ $pricing->extension }}</span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                        {{ format_currency($pricing->register_price) }}
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                        {{ format_currency($pricing->renew_price) }}
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                        {{ format_currency($pricing->transfer_price) }}
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <span class="px-2 py-1 text-xs font-semibold rounded-full {{ $pricing->active ? 'bg-green-900 text-green-300' : 'bg-red-900 text-red-300' }}">
                            {{ $pricing->active ? 'Active' : 'Inactive' }}
                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium space-x-2">
                        <a href="{{ route('admin.domain-pricing.edit', $pricing) }}" class="text-blue-400 hover:text-blue-300">Edit</a>
                        <form action="{{ route('admin.domain-pricing.destroy', $pricing) }}" method="POST" class="inline" onsubmit="return confirm('Are you sure?')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="text-red-400 hover:text-red-300">Delete</button>
                        </form>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="6" class="px-6 py-8 text-center text-gray-400">
                        No domain pricing found. <a href="{{ route('admin.domain-pricing.create') }}" class="text-blue-400 hover:text-blue-300">Add your first domain TLD</a>
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    @if($domainPricing->hasPages())
        <div class="mt-6">
            {{ $domainPricing->links() }}
        </div>
    @endif
</div>
@endsection
