@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-3xl font-bold text-white">Email Templates</h1>
        <a href="{{ route('admin.email-templates.create') }}" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg transition duration-300">
            Add New Template
        </a>
    </div>

    @if(session('success'))
        <div class="bg-green-500/10 border border-green-500 text-green-500 px-4 py-3 rounded-lg mb-4">
            {{ session('success') }}
        </div>
    @endif

    <div class="bg-gray-800 rounded-xl shadow-lg overflow-hidden">
        <table class="w-full">
            <thead class="bg-gray-900">
                <tr>
                    <th class="px-6 py-4 text-left text-xs font-medium text-gray-400 uppercase">Name</th>
                    <th class="px-6 py-4 text-left text-xs font-medium text-gray-400 uppercase">Slug</th>
                    <th class="px-6 py-4 text-left text-xs font-medium text-gray-400 uppercase">Subject</th>
                    <th class="px-6 py-4 text-right text-xs font-medium text-gray-400 uppercase">Actions</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-700">
                @forelse($templates as $template)
                <tr>
                    <td class="px-6 py-4 text-white">{{ $template->name }}</td>
                    <td class="px-6 py-4 text-gray-400">{{ $template->slug }}</td>
                    <td class="px-6 py-4 text-gray-400">{{ Str::limit($template->subject, 50) }}</td>
                    <td class="px-6 py-4 text-right space-x-2">
                        <a href="{{ route('admin.email-templates.edit', $template) }}" class="text-blue-400 hover:text-blue-300">Edit</a>
                        <form action="{{ route('admin.email-templates.destroy', $template) }}" method="POST" class="inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="text-red-400 hover:text-red-300" onclick="return confirm('Are you sure?')">Delete</button>
                        </form>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="4" class="px-6 py-8 text-center text-gray-400">No email templates found</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <div class="mt-4">
        {{ $templates->links() }}
    </div>
</div>
@endsection
