@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-3xl font-bold text-white">Module Manager</h1>
    </div>

    @if(session('success'))
        <div class="bg-green-500/10 border border-green-500 text-green-500 px-4 py-3 rounded-lg mb-4">
            {{ session('success') }}
        </div>
    @endif

    @if(session('error'))
        <div class="bg-red-500/10 border border-red-500 text-red-500 px-4 py-3 rounded-lg mb-4">
            {{ session('error') }}
        </div>
    @endif

    <div class="bg-gray-800 rounded-xl p-6 mb-6">
        <h2 class="text-xl font-semibold text-white mb-4">Upload New Module</h2>
        <form action="{{ route('admin.modules.upload') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="flex gap-4">
                <input type="file" name="module_file" accept=".zip" required
                    class="flex-1 px-4 py-2 bg-gray-700 border border-gray-600 rounded-lg text-white">
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg transition duration-300">
                    Upload Module
                </button>
            </div>
            <p class="text-gray-400 text-sm mt-2">Upload a ZIP file containing the module with module.json</p>
        </form>
    </div>

    <div class="bg-gray-800 rounded-xl shadow-lg overflow-hidden">
        <div class="p-6 border-b border-gray-700">
            <h2 class="text-xl font-semibold text-white">Installed Modules</h2>
        </div>
        <table class="w-full">
            <thead class="bg-gray-900">
                <tr>
                    <th class="px-6 py-4 text-left text-xs font-medium text-gray-400 uppercase">Name</th>
                    <th class="px-6 py-4 text-left text-xs font-medium text-gray-400 uppercase">Type</th>
                    <th class="px-6 py-4 text-left text-xs font-medium text-gray-400 uppercase">Version</th>
                    <th class="px-6 py-4 text-left text-xs font-medium text-gray-400 uppercase">Status</th>
                    <th class="px-6 py-4 text-right text-xs font-medium text-gray-400 uppercase">Actions</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-700">
                @forelse($modules as $module)
                <tr>
                    <td class="px-6 py-4 text-white">{{ $module->name }}</td>
                    <td class="px-6 py-4 text-gray-400">{{ ucfirst($module->type) }}</td>
                    <td class="px-6 py-4 text-gray-400">{{ $module->version }}</td>
                    <td class="px-6 py-4">
                        <span class="px-3 py-1 rounded-full text-xs {{ $module->status === 'active' ? 'bg-green-500/10 text-green-500' : 'bg-gray-700 text-gray-400' }}">
                            {{ ucfirst($module->status) }}
                        </span>
                    </td>
                    <td class="px-6 py-4 text-right space-x-2">
                        <form action="{{ route('admin.modules.toggle', $module) }}" method="POST" class="inline">
                            @csrf
                            <button type="submit" class="text-blue-400 hover:text-blue-300">
                                {{ $module->status === 'active' ? 'Deactivate' : 'Activate' }}
                            </button>
                        </form>
                        <form action="{{ route('admin.modules.uninstall', $module) }}" method="POST" class="inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="text-red-400 hover:text-red-300" onclick="return confirm('Are you sure you want to uninstall this module?')">
                                Uninstall
                            </button>
                        </form>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="5" class="px-6 py-8 text-center text-gray-400">No modules installed</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
@endsection
