@extends('layouts.app')

@section('title', 'All Orders')

@section('content')
<div class="min-h-screen bg-gray-900 p-6">
    <div class="max-w-7xl mx-auto">
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-white mb-2">All Orders</h1>
            <p class="text-gray-400">View and manage all orders in the system</p>
        </div>

        <!-- Stats -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
            <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                <div class="text-gray-400 text-sm mb-1">Total Orders</div>
                <div class="text-3xl font-bold text-white">{{ $orders->total() }}</div>
            </div>
            <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                <div class="text-gray-400 text-sm mb-1">Pending</div>
                <div class="text-3xl font-bold text-yellow-500">{{ $orders->where('status', 'pending')->count() }}</div>
            </div>
            <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                <div class="text-gray-400 text-sm mb-1">Active</div>
                <div class="text-3xl font-bold text-green-500">{{ $orders->where('status', 'active')->count() }}</div>
            </div>
            <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                <div class="text-gray-400 text-sm mb-1">Cancelled</div>
                <div class="text-3xl font-bold text-red-500">{{ $orders->where('status', 'cancelled')->count() }}</div>
            </div>
        </div>

        <!-- Orders Table -->
        <div class="bg-gray-800 border border-gray-700 rounded-xl overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gray-750">
                        <tr>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">ID</th>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Client</th>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Service</th>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Price</th>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Status</th>
                            <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Date</th>
                            <th class="px-6 py-4 text-right text-xs font-semibold text-gray-400 uppercase">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-700">
                        @forelse($orders as $order)
                            <tr class="hover:bg-gray-750 transition">
                                <td class="px-6 py-4 text-gray-300">#{{ $order->id }}</td>
                                <td class="px-6 py-4">
                                    <div class="text-white font-medium">{{ $order->user->name }}</div>
                                    <div class="text-sm text-gray-400">{{ $order->user->email }}</div>
                                </td>
                                <td class="px-6 py-4 text-gray-300">{{ $order->name }}</td>
                                <td class="px-6 py-4 text-gray-300">{{ format_currency($order->price) }}</td>
                                <td class="px-6 py-4">
                                    @if($order->status === 'active')
                                        <span class="px-2 py-1 bg-green-500/20 text-green-400 rounded text-sm">Active</span>
                                    @elseif($order->status === 'pending')
                                        <span class="px-2 py-1 bg-yellow-500/20 text-yellow-400 rounded text-sm">Pending</span>
                                    @elseif($order->status === 'suspended')
                                        <span class="px-2 py-1 bg-orange-500/20 text-orange-400 rounded text-sm">Suspended</span>
                                    @else
                                        <span class="px-2 py-1 bg-red-500/20 text-red-400 rounded text-sm">Cancelled</span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 text-gray-400 text-sm">{{ $order->created_at->format('M d, Y') }}</td>
                                <td class="px-6 py-4 text-right">
                                    <a href="{{ route('admin.services.show', $order->id) }}" class="text-blue-400 hover:text-blue-300 transition">View</a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="px-6 py-12 text-center text-gray-400">No orders found</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            @if($orders->hasPages())
                <div class="px-6 py-4 border-t border-gray-700">
                    {{ $orders->links() }}
                </div>
            @endif
        </div>
    </div>
</div>
@endsection