@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-3xl font-bold text-white">Payment Gateways</h1>
        <a href="{{ route('admin.gateways.create') }}" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg">
            Add Gateway
        </a>
    </div>

    @if(session('success'))
        <div class="bg-green-600 text-white p-4 rounded-lg mb-6">
            {{ session('success') }}
        </div>
    @endif

    <div class="bg-gray-800 rounded-lg shadow-lg overflow-hidden">
        <table class="w-full">
            <thead class="bg-gray-700">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase">Name</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase">Display Name</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase">Currencies</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase">Fee</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase">Mode</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase">Actions</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-700">
                @forelse($gateways as $gateway)
                    <tr>
                        <td class="px-6 py-4 text-gray-300">{{ $gateway->name }}</td>
                        <td class="px-6 py-4 text-gray-300">{{ $gateway->display_name }}</td>
                        <td class="px-6 py-4 text-gray-400 text-sm">
                            {{ is_array($gateway->supported_currencies) ? implode(', ', $gateway->supported_currencies) : '' }}
                        </td>
                        <td class="px-6 py-4 text-gray-400 text-sm">
                            {{ $gateway->transaction_fee_percentage }}% + {{ $gateway->transaction_fee_fixed }}
                        </td>
                        <td class="px-6 py-4">
                            <span class="px-2 py-1 text-xs rounded {{ $gateway->is_test_mode ? 'bg-yellow-600' : 'bg-green-600' }} text-white">
                                {{ $gateway->is_test_mode ? 'Test' : 'Live' }}
                            </span>
                        </td>
                        <td class="px-6 py-4">
                            <form action="{{ route('admin.gateways.toggle', $gateway) }}" method="POST" class="inline">
                                @csrf
                                <button type="submit" class="px-3 py-1 text-xs rounded {{ $gateway->is_active ? 'bg-green-600 hover:bg-green-700' : 'bg-red-600 hover:bg-red-700' }} text-white">
                                    {{ $gateway->is_active ? 'Active' : 'Inactive' }}
                                </button>
                            </form>
                        </td>
                        <td class="px-6 py-4">
                            <div class="flex space-x-2">
                                <a href="{{ route('admin.gateways.edit', $gateway) }}" class="text-blue-400 hover:text-blue-300">Edit</a>
                                <form action="{{ route('admin.gateways.destroy', $gateway) }}" method="POST" class="inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-red-400 hover:text-red-300" onclick="return confirm('Are you sure?')">Delete</button>
                                </form>
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="7" class="px-6 py-8 text-center text-gray-400">No payment gateways configured</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <div class="mt-8 bg-gray-800 rounded-lg p-6">
        <h2 class="text-xl font-bold text-white mb-4">Webhook URLs</h2>
        <div class="space-y-2 text-gray-300">
            <p><strong>PayPal:</strong> <code class="bg-gray-700 px-2 py-1 rounded">{{ url('/webhooks/paypal') }}</code></p>
            <p><strong>Stripe:</strong> <code class="bg-gray-700 px-2 py-1 rounded">{{ url('/webhooks/stripe') }}</code></p>
            <p><strong>Paystack:</strong> <code class="bg-gray-700 px-2 py-1 rounded">{{ url('/webhooks/paystack') }}</code></p>
            <p><strong>Flutterwave:</strong> <code class="bg-gray-700 px-2 py-1 rounded">{{ url('/webhooks/flutterwave') }}</code></p>
            <p><strong>Razorpay:</strong> <code class="bg-gray-700 px-2 py-1 rounded">{{ url('/webhooks/razorpay') }}</code></p>
        </div>
    </div>
</div>
@endsection
