@extends('layouts.app')
@section('title', 'Add Product')
@section('content')
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8" x-data="productForm()">
    <div class="mb-6">
        <a href="{{ route('admin.products.index') }}" class="text-blue-400 hover:text-blue-300">&larr; Back to Products</a>
    </div>

    <div class="bg-gray-800 shadow rounded-lg border border-gray-700 p-8">
        <h1 class="text-2xl font-bold text-white mb-6">Add New Product</h1>

        <form action="{{ route('admin.products.store') }}" method="POST">
            @csrf

            <div class="space-y-6">
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Product Name *</label>
                    <input type="text" name="name" value="{{ old('name') }}" required
                        placeholder="e.g., Starter Hosting"
                        class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                    @error('name')<p class="mt-1 text-sm text-red-400">{{ $message }}</p>@enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Description</label>
                    <textarea name="description" rows="3"
                        class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">{{ old('description') }}</textarea>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-2">Product Type *</label>
                        <select name="type" required
                            class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="hosting">Shared Hosting</option>
                            <option value="vps">VPS Hosting</option>
                            <option value="dedicated">Dedicated Server</option>
                            <option value="domain">Domain</option>
                        </select>
                        @error('type')<p class="mt-1 text-sm text-red-400">{{ $message }}</p>@enderror
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-300 mb-2">Server</label>
                        <select name="server_id"
                            class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="">No Server</option>
                            @foreach($servers as $server)
                                <option value="{{ $server->id }}">{{ $server->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Features (JSON)</label>
                    <textarea name="features" rows="4" placeholder='{"disk": "10GB", "bandwidth": "100GB", "databases": "10"}'
                        class="w-full px-4 py-2 bg-gray-900 border border-gray-700 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-blue-500 font-mono text-sm">{{ old('features') }}</textarea>
                    <p class="mt-1 text-xs text-gray-400">Enter as JSON object or leave blank</p>
                </div>

                <div>
                    <label class="flex items-center">
                        <input type="checkbox" name="active" value="1" checked
                            class="rounded border-gray-700 text-blue-600 bg-gray-900 focus:ring-blue-500">
                        <span class="ml-2 text-sm text-gray-300">Active</span>
                    </label>
                </div>

                <div class="border-t border-gray-700 pt-6">
                    <div class="flex justify-between items-center mb-4">
                        <h3 class="text-lg font-semibold text-white">Pricing Configuration</h3>
                        <button type="button" @click="addPricing()" class="px-3 py-1 bg-blue-600 hover:bg-blue-700 text-white text-sm rounded">
                            Add Billing Cycle
                        </button>
                    </div>

                    <div class="space-y-4">
                        <template x-for="(price, index) in pricingList" :key="index">
                            <div class="bg-gray-900 p-4 rounded-lg border border-gray-700">
                                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                    <div>
                                        <label class="block text-sm text-gray-400 mb-2">Billing Cycle</label>
                                        <select :name="'pricing['+index+'][billing_cycle]'" x-model="price.cycle" required
                                            class="w-full px-3 py-2 bg-gray-800 border border-gray-600 rounded text-white text-sm">
                                            <option value="monthly">Monthly</option>
                                            <option value="quarterly">Quarterly</option>
                                            <option value="semi-annually">Semi-Annually</option>
                                            <option value="annually">Annually</option>
                                            <option value="biennially">Biennially</option>
                                            <option value="triennially">Triennially</option>
                                        </select>
                                    </div>
                                    <div>
                                        <label class="block text-sm text-gray-400 mb-2">Price</label>
                                        <input type="number" step="0.01" :name="'pricing['+index+'][price]'" x-model="price.price" required
                                            class="w-full px-3 py-2 bg-gray-800 border border-gray-600 rounded text-white text-sm">
                                    </div>
                                    <div>
                                        <label class="block text-sm text-gray-400 mb-2">Setup Fee</label>
                                        <div class="flex gap-2">
                                            <input type="number" step="0.01" :name="'pricing['+index+'][setup_fee]'" x-model="price.setup_fee"
                                                class="w-full px-3 py-2 bg-gray-800 border border-gray-600 rounded text-white text-sm">
                                            <button type="button" @click="removePricing(index)" class="px-3 py-2 bg-red-600 hover:bg-red-700 text-white text-sm rounded">
                                                ×
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </template>
                    </div>
                </div>

                <div class="mt-8 flex space-x-4">
                    <button type="submit" class="px-6 py-3 bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700 text-white font-semibold rounded-lg transition shadow-lg">
                        Create Product
                    </button>
                    <a href="{{ route('admin.products.index') }}" class="px-6 py-3 bg-gray-700 hover:bg-gray-600 text-white font-semibold rounded-lg transition">
                        Cancel
                    </a>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
function productForm() {
    return {
        pricingList: [
            { cycle: 'monthly', price: '', setup_fee: '0' }
        ],
        addPricing() {
            this.pricingList.push({ cycle: 'monthly', price: '', setup_fee: '0' });
        },
        removePricing(index) {
            if (this.pricingList.length > 1) {
                this.pricingList.splice(index, 1);
            }
        }
    }
}
</script>
@endsection
