@extends('layouts.app')
@section('title', 'Servers Management')
@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-3xl font-bold text-white">Servers Management</h1>
        <a href="{{ route('admin.servers.create') }}" class="px-4 py-2 bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700 text-white font-semibold rounded-lg transition shadow-lg">
            Add New Server
        </a>
    </div>

    @if(session('success'))
        <div class="mb-4 p-4 bg-green-900 border border-green-700 text-green-300 rounded-lg">
            {{ session('success') }}
        </div>
    @endif

    <div class="bg-gray-800 shadow rounded-lg border border-gray-700 overflow-hidden">
        <table class="min-w-full divide-y divide-gray-700">
            <thead class="bg-gray-900">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Name</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Type</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Hostname</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">IP Address</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Accounts</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Actions</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-700">
                @forelse($servers as $server)
                <tr class="hover:bg-gray-700">
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm font-medium text-white">{{ $server->name }}</div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <span class="px-2 py-1 text-xs font-semibold rounded-full {{ $server->type === 'cpanel' ? 'bg-blue-900 text-blue-300' : 'bg-purple-900 text-purple-300' }}">
                            {{ strtoupper($server->type) }}
                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">{{ $server->hostname }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">{{ $server->ip_address }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                        {{ $server->accounts_count }}{{ $server->max_accounts > 0 ? ' / ' . $server->max_accounts : '' }}
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <span class="px-2 py-1 text-xs font-semibold rounded-full {{ $server->active ? 'bg-green-900 text-green-300' : 'bg-red-900 text-red-300' }}">
                            {{ $server->active ? 'Active' : 'Inactive' }}
                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium space-x-2">
                        <a href="{{ route('admin.servers.edit', $server) }}" class="text-blue-400 hover:text-blue-300">Edit</a>
                        <a href="{{ route('admin.servers.show', $server) }}" class="text-green-400 hover:text-green-300">View</a>
                        <form action="{{ route('admin.servers.destroy', $server) }}" method="POST" class="inline" onsubmit="return confirm('Are you sure?')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="text-red-400 hover:text-red-300">Delete</button>
                        </form>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="7" class="px-6 py-8 text-center text-gray-400">
                        No servers found. <a href="{{ route('admin.servers.create') }}" class="text-blue-400 hover:text-blue-300">Add your first server</a>
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    @if($servers->hasPages())
        <div class="mt-6">
            {{ $servers->links() }}
        </div>
    @endif
</div>
@endsection
