@extends('layouts.app')
@section('title', 'Payment Gateway Settings')
@section('content')
<div class="min-h-screen bg-gray-900 p-6">
    <div class="max-w-7xl mx-auto">
        <nav class="flex mb-6">
            <ol class="inline-flex items-center space-x-1 md:space-x-3">
                <li><a href="{{ route('admin.dashboard') }}" class="text-gray-400 hover:text-white">Admin</a></li>
                <li><div class="flex items-center"><svg class="w-6 h-6 text-gray-400" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path></svg><a href="{{ route('admin.settings.index') }}" class="ml-1 text-gray-400 hover:text-white">Settings</a></div></li>
                <li><div class="flex items-center"><svg class="w-6 h-6 text-gray-400" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path></svg><span class="ml-1 text-gray-500">Payment Gateways</span></div></li>
            </ol>
        </nav>
        <div class="mb-8"><h1 class="text-3xl font-bold text-white mb-2">Payment Gateway Settings</h1><p class="text-gray-400">Manage payment processors, API keys, and transaction settings</p></div>
        <div class="bg-gray-800 border border-gray-700 rounded-xl p-6"><div class="text-center py-12"><div class="w-16 h-16 bg-green-500/10 rounded-xl flex items-center justify-center mx-auto mb-4"><svg class="w-8 h-8 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path></svg></div><h3 class="text-lg font-semibold text-white mb-2">Payment Gateway Configuration</h3><p class="text-gray-400 mb-6">Payment gateway settings will be available here</p><a href="{{ route('admin.settings.index') }}" class="inline-flex items-center px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition"><svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path></svg>Back to Settings</a></div></div>
    </div>
</div>
@endsection
