@extends('layouts.app')
@section('title', 'Closed Tickets')
@section('content')
<div class="min-h-screen bg-gray-900 p-6">
    <div class="max-w-7xl mx-auto">
        <div class="mb-8 flex items-center justify-between">
            <div>
                <h1 class="text-3xl font-bold text-white mb-2">Closed Tickets</h1>
                <p class="text-gray-400">View and manage all support tickets</p>
            </div>
            <a href="{{ route('admin.new.ticket') }}" class="px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-lg">
                New Ticket
            </a>
        </div>
        
        <div class="bg-gray-800 border border-gray-700 rounded-xl overflow-hidden">
            <table class="w-full">
                <thead class="bg-gray-750">
                    <tr>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Ticket #</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Subject</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Client</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Priority</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Status</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Updated</th>
                        <th class="px-6 py-4 text-right text-xs font-semibold text-gray-400 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    @forelse($tickets as $ticket)
                        <tr class="hover:bg-gray-750">
                            <td class="px-6 py-4 text-gray-300">{{ $ticket->ticket_number }}</td>
                            <td class="px-6 py-4 text-white font-medium">{{ $ticket->subject }}</td>
                            <td class="px-6 py-4 text-gray-300">{{ $ticket->user->name }}</td>
                            <td class="px-6 py-4">
                                @if($ticket->priority === 'high')
                                    <span class="px-2 py-1 bg-red-500/20 text-red-400 rounded text-sm">High</span>
                                @elseif($ticket->priority === 'medium')
                                    <span class="px-2 py-1 bg-yellow-500/20 text-yellow-400 rounded text-sm">Medium</span>
                                @else
                                    <span class="px-2 py-1 bg-green-500/20 text-green-400 rounded text-sm">Low</span>
                                @endif
                            </td>
                            <td class="px-6 py-4">
                                @if($ticket->status === 'open')
                                    <span class="px-2 py-1 bg-blue-500/20 text-blue-400 rounded text-sm">Open</span>
                                @elseif($ticket->status === 'closed')
                                    <span class="px-2 py-1 bg-gray-500/20 text-gray-400 rounded text-sm">Closed</span>
                                @else
                                    <span class="px-2 py-1 bg-purple-500/20 text-purple-400 rounded text-sm">{{ ucwords(str_replace('-', ' ', $ticket->status)) }}</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 text-gray-400 text-sm">{{ $ticket->updated_at->diffForHumans() }}</td>
                            <td class="px-6 py-4 text-right">
                                <a href="{{ route('admin.tickets.show', $ticket->id) }}" class="text-blue-400 hover:text-blue-300">View</a>
                            </td>
                        </tr>
                    @empty
                        <tr><td colspan="7" class="px-6 py-12 text-center text-gray-400">No tickets found</td></tr>
                    @endforelse
                </tbody>
            </table>
            @if($tickets->hasPages())
                <div class="px-6 py-4 border-t border-gray-700">{{ $tickets->links() }}</div>
            @endif
        </div>
    </div>
</div>
@endsection
