@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-3xl font-bold text-white">Template Manager</h1>
    </div>

    @if(session('success'))
        <div class="bg-green-500/10 border border-green-500 text-green-500 px-4 py-3 rounded-lg mb-4">
            {{ session('success') }}
        </div>
    @endif

    @if(session('error'))
        <div class="bg-red-500/10 border border-red-500 text-red-500 px-4 py-3 rounded-lg mb-4">
            {{ session('error') }}
        </div>
    @endif

    <div class="bg-gray-800 rounded-xl p-6 mb-6">
        <h2 class="text-xl font-semibold text-white mb-4">Upload New Template</h2>
        <form action="{{ route('admin.templates.upload') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="flex gap-4">
                <input type="file" name="template_file" accept=".zip" required
                    class="flex-1 px-4 py-2 bg-gray-700 border border-gray-600 rounded-lg text-white">
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg transition duration-300">
                    Upload Template
                </button>
            </div>
            <p class="text-gray-400 text-sm mt-2">Upload a ZIP file containing the template with template.json</p>
        </form>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        @forelse($templates as $template)
        <div class="bg-gray-800 rounded-xl overflow-hidden">
            <div class="p-6">
                <h3 class="text-xl font-semibold text-white mb-2">{{ $template->name }}</h3>
                <p class="text-gray-400 text-sm mb-1">Version: {{ $template->version }}</p>
                <p class="text-gray-400 text-sm mb-4">Author: {{ $template->author }}</p>
                
                @if($template->active)
                    <span class="inline-block px-3 py-1 rounded-full text-xs bg-green-500/10 text-green-500 mb-4">
                        Active
                    </span>
                @endif

                <div class="flex gap-2 mt-4">
                    @if(!$template->active)
                        <form action="{{ route('admin.templates.activate', $template) }}" method="POST" class="flex-1">
                            @csrf
                            <button type="submit" class="w-full bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg transition duration-300">
                                Activate
                            </button>
                        </form>
                    @endif
                    
                    @if(!$template->active)
                        <form action="{{ route('admin.templates.uninstall', $template) }}" method="POST">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded-lg transition duration-300" onclick="return confirm('Are you sure?')">
                                Uninstall
                            </button>
                        </form>
                    @endif
                </div>
            </div>
        </div>
        @empty
        <div class="col-span-full text-center py-12 text-gray-400">
            No templates installed
        </div>
        @endforelse
    </div>
</div>
@endsection
