@extends('layouts.app')
@section('title', 'Tickets')
@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <h1 class="text-3xl font-bold mb-6">Tickets Management</h1>
    <div class="bg-white shadow rounded-lg p-6">
        <table class="min-w-full">
            <thead>
                <tr class="border-b">
                    <th class="text-left py-2">Subject</th>
                    <th class="text-left py-2">User</th>
                    <th class="text-left py-2">Status</th>
                    <th class="text-left py-2">Priority</th>
                    <th class="text-left py-2">Created</th>
                </tr>
            </thead>
            <tbody>
                @foreach($tickets as $ticket)
                <tr class="border-b">
                    <td class="py-2">{{ $ticket->subject }}</td>
                    <td class="py-2">{{ $ticket->user->name }}</td>
                    <td class="py-2"><span class="px-2 py-1 text-xs rounded bg-blue-100 text-blue-800">{{ $ticket->status }}</span></td>
                    <td class="py-2"><span class="px-2 py-1 text-xs rounded bg-yellow-100 text-yellow-800">{{ $ticket->priority }}</span></td>
                    <td class="py-2">{{ $ticket->created_at->format('M d, Y') }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection
