@extends('layouts.app')
@section('title', 'Add Funds')
@section('content')
<div class="min-h-screen bg-gray-900 p-6">
    <div class="max-w-4xl mx-auto">
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-white mb-2">Add Funds</h1>
            <p class="text-gray-400">Add credit to your account</p>
        </div>

        <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
            <form class="space-y-6">
                @csrf
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Amount</label>
                    <div class="relative">
                        <span class="absolute left-4 top-3 text-gray-400">$</span>
                        <input type="number" name="amount" min="10" step="0.01" placeholder="0.00" class="w-full pl-8 pr-4 py-3 bg-gray-900 border border-gray-700 rounded-lg text-white text-lg">
                    </div>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Payment Method</label>
                    <select name="gateway" class="w-full px-4 py-3 bg-gray-900 border border-gray-700 rounded-lg text-white">
                        <option>PayPal</option>
                        <option>Stripe</option>
                        <option>Credit Card</option>
                    </select>
                </div>

                <button type="submit" class="w-full px-6 py-3 bg-blue-600 hover:bg-blue-700 text-white rounded-lg text-lg font-medium">Add Funds</button>
            </form>
        </div>

        <div class="mt-6 bg-blue-500/20 border border-blue-500 rounded-xl p-4">
            <p class="text-blue-400 text-sm">💡 Funds added to your account can be used for future invoices and services.</p>
        </div>
    </div>
</div>
@endsection