@extends('layouts.app')

@section('title', 'Dashboard')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <!-- Welcome Banner -->
    <div class="bg-gradient-to-r from-blue-600 to-purple-600 rounded-2xl p-8 mb-8 shadow-xl">
        <div class="flex items-center justify-between flex-wrap gap-4">
            <div>
                <h1 class="text-3xl font-bold text-white mb-2">Welcome back, {{ auth()->user()->name }}!</h1>
                <p class="text-blue-100">Here's what's happening with your account today.</p>
            </div>
            <div class="flex items-center space-x-4">
                <div class="text-right">
                    <p class="text-sm text-blue-100">Account Balance</p>
                    <p class="text-2xl font-bold text-white">{{ '$' . number_format($accountBalance, 2) }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions Bar -->
    <div class="mb-8">
        <h2 class="text-lg font-semibold text-gray-300 mb-4">Quick Actions</h2>
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
            <a href="#" class="bg-gray-800 hover:bg-gray-700 border border-gray-700 rounded-xl p-4 text-center transition-all hover:scale-105 hover:shadow-lg">
                <div class="w-12 h-12 bg-gradient-to-r from-blue-500 to-blue-600 rounded-lg flex items-center justify-center mx-auto mb-3">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                    </svg>
                </div>
                <p class="text-sm font-medium text-gray-300">Order New Service</p>
            </a>
            <a href="#" class="bg-gray-800 hover:bg-gray-700 border border-gray-700 rounded-xl p-4 text-center transition-all hover:scale-105 hover:shadow-lg">
                <div class="w-12 h-12 bg-gradient-to-r from-green-500 to-green-600 rounded-lg flex items-center justify-center mx-auto mb-3">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z"></path>
                    </svg>
                </div>
                <p class="text-sm font-medium text-gray-300">Open Support Ticket</p>
            </a>
            <a href="#" class="bg-gray-800 hover:bg-gray-700 border border-gray-700 rounded-xl p-4 text-center transition-all hover:scale-105 hover:shadow-lg">
                <div class="w-12 h-12 bg-gradient-to-r from-purple-500 to-purple-600 rounded-lg flex items-center justify-center mx-auto mb-3">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <p class="text-sm font-medium text-gray-300">Add Funds</p>
            </a>
            <a href="#" class="bg-gray-800 hover:bg-gray-700 border border-gray-700 rounded-xl p-4 text-center transition-all hover:scale-105 hover:shadow-lg">
                <div class="w-12 h-12 bg-gradient-to-r from-orange-500 to-orange-600 rounded-lg flex items-center justify-center mx-auto mb-3">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                    </svg>
                </div>
                <p class="text-sm font-medium text-gray-300">Account Settings</p>
            </a>
        </div>
    </div>

    <!-- Dashboard Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
        <!-- Services Card -->
        <a href="{{ route('client.services.index') }}" class="bg-gray-800 border border-gray-700 rounded-2xl p-6 hover:border-blue-500 transition-all hover:shadow-xl group">
            <div class="flex items-center justify-between mb-4">
                <div class="w-14 h-14 bg-gradient-to-r from-blue-500 to-blue-600 rounded-xl flex items-center justify-center group-hover:scale-110 transition-transform">
                    <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 12h14M5 12a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v4a2 2 0 01-2 2M5 12a2 2 0 00-2 2v4a2 2 0 002 2h14a2 2 0 002-2v-4a2 2 0 00-2-2m-2-4h.01M17 16h.01"></path>
                    </svg>
                </div>
                <span class="text-xs font-medium px-3 py-1 bg-green-500/10 text-green-500 rounded-full">Active</span>
            </div>
            <h3 class="text-gray-400 text-sm font-medium mb-1">Services</h3>
            <p class="text-3xl font-bold text-white mb-2">{{ $services->count() }}</p>
            <p class="text-xs text-gray-500">{{ $services->where('status', 'active')->count() }} active services</p>
        </a>

        <!-- Domains Card -->
        <a href="#" class="bg-gray-800 border border-gray-700 rounded-2xl p-6 hover:border-purple-500 transition-all hover:shadow-xl group">
            <div class="flex items-center justify-between mb-4">
                <div class="w-14 h-14 bg-gradient-to-r from-purple-500 to-purple-600 rounded-xl flex items-center justify-center group-hover:scale-110 transition-transform">
                    <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 12a9 9 0 01-9 9m9-9a9 9 0 00-9-9m9 9H3m9 9a9 9 0 01-9-9m9 9c1.657 0 3-4.03 3-9s-1.343-9-3-9m0 18c-1.657 0-3-4.03-3-9s1.343-9 3-9m-9 9a9 9 0 019-9"></path>
                    </svg>
                </div>
                <span class="text-xs font-medium px-3 py-1 bg-purple-500/10 text-purple-500 rounded-full">Registered</span>
            </div>
            <h3 class="text-gray-400 text-sm font-medium mb-1">Domains</h3>
            <p class="text-3xl font-bold text-white mb-2">{{ $domains->count() }}</p>
            <p class="text-xs text-gray-500">{{ $domains->count() }} domains registered</p>
        </a>

        <!-- Tickets Card -->
        <a href="{{ route('client.tickets.index') }}" class="bg-gray-800 border border-gray-700 rounded-2xl p-6 hover:border-green-500 transition-all hover:shadow-xl group">
            <div class="flex items-center justify-between mb-4">
                <div class="w-14 h-14 bg-gradient-to-r from-green-500 to-green-600 rounded-xl flex items-center justify-center group-hover:scale-110 transition-transform">
                    <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z"></path>
                    </svg>
                </div>
                @if($tickets->where('status', 'open')->count() > 0)
                    <span class="text-xs font-medium px-3 py-1 bg-yellow-500/10 text-yellow-500 rounded-full">Open</span>
                @else
                    <span class="text-xs font-medium px-3 py-1 bg-gray-700 text-gray-500 rounded-full">None</span>
                @endif
            </div>
            <h3 class="text-gray-400 text-sm font-medium mb-1">Support Tickets</h3>
            <p class="text-3xl font-bold text-white mb-2">{{ $tickets->count() }}</p>
            <p class="text-xs text-gray-500">{{ $tickets->where('status', 'open')->count() }} open tickets</p>
        </a>

        <!-- Invoices Card -->
        <a href="{{ route('client.invoices.index') }}" class="bg-gray-800 border border-gray-700 rounded-2xl p-6 hover:border-orange-500 transition-all hover:shadow-xl group">
            <div class="flex items-center justify-between mb-4">
                <div class="w-14 h-14 bg-gradient-to-r from-orange-500 to-orange-600 rounded-xl flex items-center justify-center group-hover:scale-110 transition-transform">
                    <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                </div>
                @if($invoices->where('status', 'unpaid')->count() > 0)
                    <span class="text-xs font-medium px-3 py-1 bg-red-500/10 text-red-500 rounded-full">Unpaid</span>
                @else
                    <span class="text-xs font-medium px-3 py-1 bg-green-500/10 text-green-500 rounded-full">Paid</span>
                @endif
            </div>
            <h3 class="text-gray-400 text-sm font-medium mb-1">Invoices</h3>
            <p class="text-3xl font-bold text-white mb-2">{{ $invoices->count() }}</p>
            <p class="text-xs text-gray-500">{{ $invoices->where('status', 'unpaid')->count() }} unpaid invoices</p>
        </a>
    </div>

    <!-- Recent Activity Sections -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Recent Services -->
        <div class="bg-gray-800 border border-gray-700 rounded-2xl p-6">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-xl font-semibold text-white">Recent Services</h3>
                <a href="{{ route('client.services.index') }}" class="text-sm text-blue-400 hover:text-blue-300 transition">View All →</a>
            </div>
            @if($services->count())
                <div class="space-y-3">
                    @foreach($services as $service)
                        <div class="flex items-center justify-between p-4 bg-gray-700/50 rounded-xl hover:bg-gray-700 transition">
                            <div class="flex items-center space-x-3">
                                <div class="w-10 h-10 bg-gradient-to-r from-blue-500 to-blue-600 rounded-lg flex items-center justify-center">
                                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 12h14M5 12a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v4a2 2 0 01-2 2M5 12a2 2 0 00-2 2v4a2 2 0 002 2h14a2 2 0 002-2v-4a2 2 0 00-2-2m-2-4h.01M17 16h.01"></path>
                                    </svg>
                                </div>
                                <div>
                                    <p class="text-sm font-medium text-white">{{ $service->name }}</p>
                                    <p class="text-xs text-gray-400">{{ $service->product->name ?? 'Service' }}</p>
                                </div>
                            </div>
                            <span class="px-3 py-1 text-xs font-medium rounded-full {{ $service->status === 'active' ? 'bg-green-500/10 text-green-500' : 'bg-gray-700 text-gray-400' }}">
                                {{ ucfirst($service->status) }}
                            </span>
                        </div>
                    @endforeach
                </div>
            @else
                <div class="text-center py-12">
                    <svg class="w-16 h-16 text-gray-600 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4"></path>
                    </svg>
                    <p class="text-gray-500">No services yet</p>
                    <a href="#" class="mt-4 inline-block text-sm text-blue-400 hover:text-blue-300 transition">Order your first service →</a>
                </div>
            @endif
        </div>

        <!-- Recent Invoices -->
        <div class="bg-gray-800 border border-gray-700 rounded-2xl p-6">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-xl font-semibold text-white">Recent Invoices</h3>
                <a href="{{ route('client.invoices.index') }}" class="text-sm text-blue-400 hover:text-blue-300 transition">View All →</a>
            </div>
            @if($invoices->count())
                <div class="space-y-3">
                    @foreach($invoices as $invoice)
                        <div class="flex items-center justify-between p-4 bg-gray-700/50 rounded-xl hover:bg-gray-700 transition">
                            <div class="flex items-center space-x-3">
                                <div class="w-10 h-10 bg-gradient-to-r from-orange-500 to-orange-600 rounded-lg flex items-center justify-center">
                                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                    </svg>
                                </div>
                                <div>
                                    <p class="text-sm font-medium text-white">{{ $invoice->invoice_number }}</p>
                                    <p class="text-xs text-gray-400">${{ number_format($invoice->total, 2) }}</p>
                                </div>
                            </div>
                            <span class="px-3 py-1 text-xs font-medium rounded-full {{ $invoice->status === 'paid' ? 'bg-green-500/10 text-green-500' : 'bg-red-500/10 text-red-500' }}">
                                {{ ucfirst($invoice->status) }}
                            </span>
                        </div>
                    @endforeach
                </div>
            @else
                <div class="text-center py-12">
                    <svg class="w-16 h-16 text-gray-600 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                    <p class="text-gray-500">No invoices yet</p>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection
