@extends('layouts.app')
@section('title', 'My Domains')
@section('content')
<div class="min-h-screen bg-gray-900 p-6">
    <div class="max-w-7xl mx-auto">
        <div class="mb-8 flex items-center justify-between">
            <div>
                <h1 class="text-3xl font-bold text-white mb-2">My Domains</h1>
                <p class="text-gray-400">Manage your domain registrations</p>
            </div>
            <a href="{{ route('client.domains.register') }}" class="px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-lg">Register Domain</a>
        </div>

        <!-- Stats -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
            <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                <div class="text-gray-400 text-sm mb-1">Total Domains</div>
                <div class="text-3xl font-bold text-white">{{ $stats['total_domains'] }}</div>
            </div>
            <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                <div class="text-gray-400 text-sm mb-1">Active</div>
                <div class="text-3xl font-bold text-green-500">{{ $stats['active_domains'] }}</div>
            </div>
            <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                <div class="text-gray-400 text-sm mb-1">Expiring Soon</div>
                <div class="text-3xl font-bold text-yellow-500">{{ $stats['expiring_soon'] }}</div>
            </div>
        </div>

        <!-- Domains Table -->
        <div class="bg-gray-800 border border-gray-700 rounded-xl overflow-hidden">
            <table class="w-full">
                <thead class="bg-gray-750">
                    <tr>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Domain</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Status</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Expiry Date</th>
                        <th class="px-6 py-4 text-right text-xs font-semibold text-gray-400 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    @forelse($domains as $domain)
                        <tr class="hover:bg-gray-750">
                            <td class="px-6 py-4 text-white font-medium">{{ $domain->name }}</td>
                            <td class="px-6 py-4">
                                @if($domain->status === 'active')
                                    <span class="px-2 py-1 bg-green-500/20 text-green-400 rounded text-sm">Active</span>
                                @else
                                    <span class="px-2 py-1 bg-gray-500/20 text-gray-400 rounded text-sm">{{ ucfirst($domain->status) }}</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 text-gray-300">{{ $domain->next_due_date ? $domain->next_due_date->format('M d, Y') : 'N/A' }}</td>
                            <td class="px-6 py-4 text-right">
                                <a href="{{ route('client.services.show', $domain->id) }}" class="text-blue-400 hover:text-blue-300">Manage</a>
                            </td>
                        </tr>
                    @empty
                        <tr><td colspan="4" class="px-6 py-12 text-center text-gray-400">No domains found</td></tr>
                    @endforelse
                </tbody>
            </table>
            @if($domains->hasPages())
                <div class="px-6 py-4 border-t border-gray-700">{{ $domains->links() }}</div>
            @endif
        </div>
    </div>
</div>
@endsection