@extends('layouts.app')
@section('title', 'Domain Pricing')
@section('content')
<div class="min-h-screen bg-gray-900 p-6">
    <div class="max-w-7xl mx-auto">
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-white mb-2">Domain Pricing</h1>
            <p class="text-gray-400">View our competitive domain registration and renewal prices</p>
        </div>

        <div class="bg-gray-800 border border-gray-700 rounded-xl overflow-hidden">
            <table class="w-full">
                <thead class="bg-gray-750">
                    <tr>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Extension</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Registration</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Renewal</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-400 uppercase">Transfer</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    @forelse($domainPricing as $pricing)
                        <tr class="hover:bg-gray-750">
                            <td class="px-6 py-4 text-white font-medium">.{{ $pricing->extension }}</td>
                            <td class="px-6 py-4 text-gray-300">{{ format_currency($pricing->registration_price) }}/yr</td>
                            <td class="px-6 py-4 text-gray-300">{{ format_currency($pricing->renewal_price) }}/yr</td>
                            <td class="px-6 py-4 text-gray-300">{{ format_currency($pricing->transfer_price) }}</td>
                        </tr>
                    @empty
                        <tr><td colspan="4" class="px-6 py-12 text-center text-gray-400">No pricing information available</td></tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection