@extends('layouts.app')
@section('title', 'Register Domain')
@section('content')
<div class="min-h-screen bg-gray-900 p-6">
    <div class="max-w-4xl mx-auto">
        <div class="mb-8">
            <a href="{{ route('client.domains.index') }}" class="text-blue-400 hover:text-blue-300 text-sm mb-4 inline-block">&larr; Back to My Domains</a>
            <h1 class="text-3xl font-bold text-white mb-2">Register Domain</h1>
            <p class="text-gray-400">Search and register your perfect domain name</p>
        </div>

        <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
            <form class="space-y-6">
                @csrf
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Domain Name</label>
                    <div class="flex">
                        <input type="text" name="domain" placeholder="yourdomain" class="flex-1 px-4 py-3 bg-gray-900 border border-gray-700 rounded-l-lg text-white">
                        <select name="extension" class="px-4 py-3 bg-gray-900 border border-gray-700 text-white">
                            <option>.com</option>
                            <option>.net</option>
                            <option>.org</option>
                            <option>.io</option>
                        </select>
                        <button type="submit" class="px-6 py-3 bg-blue-600 hover:bg-blue-700 text-white rounded-r-lg">Search</button>
                    </div>
                </div>
            </form>

            <div class="mt-8">
                <p class="text-gray-400 text-sm">Popular extensions:</p>
                <div class="flex flex-wrap gap-2 mt-2">
                    <span class="px-3 py-1 bg-gray-900 border border-gray-700 rounded text-sm text-gray-300">.com</span>
                    <span class="px-3 py-1 bg-gray-900 border border-gray-700 rounded text-sm text-gray-300">.net</span>
                    <span class="px-3 py-1 bg-gray-900 border border-gray-700 rounded text-sm text-gray-300">.org</span>
                    <span class="px-3 py-1 bg-gray-900 border border-gray-700 rounded text-sm text-gray-300">.io</span>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection