@extends('layouts.app')
@section('title', 'Order Dedicated Server')
@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="text-center mb-12">
        <h1 class="text-4xl font-bold text-white mb-4">Dedicated Server Plans</h1>
        <p class="text-gray-400 text-lg">Ultimate performance with fully dedicated hardware</p>
    </div>

    @if($products->isEmpty())
        <div class="bg-gray-800 rounded-lg border border-gray-700 p-12 text-center">
            <p class="text-gray-400">No hosting plans available at the moment.</p>
        </div>
    @else
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            @foreach($products as $product)
                <div class="bg-gray-800 rounded-lg border border-gray-700 hover:border-blue-600 transition-all duration-300 overflow-hidden">
                    <div class="p-8">
                        <h3 class="text-2xl font-bold text-white mb-2">{{ $product->name }}</h3>
                        <p class="text-gray-400 mb-6 h-16">{{ $product->description ?? 'Perfect for growing websites' }}</p>

                        @if($product->features)
                            <div class="space-y-3 mb-6">
                                @foreach($product->features as $key => $value)
                                    <div class="flex items-center text-gray-300">
                                        <svg class="w-5 h-5 text-green-500 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                        </svg>
                                        <span>{{ ucfirst($key) }}: <strong class="text-white">{{ $value }}</strong></span>
                                    </div>
                                @endforeach
                            </div>
                        @endif

                        <div class="border-t border-gray-700 pt-6">
                            @php
                                $monthlyPrice = $product->pricing->where('billing_cycle', 'monthly')->first();
                            @endphp
                            @if($monthlyPrice)
                                <div class="mb-6">
                                    <div class="text-gray-400 text-sm">Starting at</div>
                                    <div class="text-4xl font-bold text-white">
                                        {{ format_currency($monthlyPrice->price) }}
                                        <span class="text-lg text-gray-400">/mo</span>
                                    </div>
                                    @if($monthlyPrice->setup_fee > 0)
                                        <div class="text-sm text-gray-400">+ {{ format_currency($monthlyPrice->setup_fee) }} setup fee</div>
                                    @endif
                                </div>
                            @endif

                            <div x-data="{ open: false, cycle: 'monthly', domain: '' }">
                                <button @click="open = !open" 
                                    class="w-full px-6 py-3 bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700 text-white font-semibold rounded-lg transition shadow-lg">
                                    Order Now
                                </button>

                                <div x-show="open" x-cloak class="mt-4 space-y-4 bg-gray-900 p-4 rounded-lg">
                                    <div>
                                        <label class="block text-sm text-gray-400 mb-2">Billing Cycle</label>
                                        <select x-model="cycle" class="w-full px-3 py-2 bg-gray-800 border border-gray-700 rounded text-white text-sm">
                                            @foreach($product->pricing as $pricing)
                                                <option value="{{ $pricing->billing_cycle }}">
                                                    {{ ucfirst($pricing->billing_cycle) }} - {{ format_currency($pricing->price) }}
                                                    @if($pricing->setup_fee > 0)
                                                        (+ {{ format_currency($pricing->setup_fee) }} setup)
                                                    @endif
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div>
                                        <label class="block text-sm text-gray-400 mb-2">Domain (Optional)</label>
                                        <input type="text" x-model="domain" placeholder="yourdomain.com"
                                            class="w-full px-3 py-2 bg-gray-800 border border-gray-700 rounded text-white text-sm">
                                    </div>

                                    <form action="{{ route('cart.add.product', $product) }}" method="POST">
                                        @csrf
                                        <input type="hidden" name="billing_cycle" :value="cycle">
                                        <input type="hidden" name="domain" :value="domain">
                                        <button type="submit" class="w-full px-4 py-2 bg-green-600 hover:bg-green-700 text-white font-semibold rounded transition">
                                            Add to Cart
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    @endif

    <div class="mt-12 bg-gray-800 rounded-lg border border-gray-700 p-8">
        <h2 class="text-2xl font-bold text-white mb-6 text-center">Why Choose Us?</h2>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <div class="text-center">
                <div class="w-16 h-16 bg-blue-600 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z" />
                    </svg>
                </div>
                <h3 class="text-lg font-semibold text-white mb-2">Lightning Fast</h3>
                <p class="text-gray-400">Optimized servers for maximum performance</p>
            </div>
            <div class="text-center">
                <div class="w-16 h-16 bg-purple-600 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                    </svg>
                </div>
                <h3 class="text-lg font-semibold text-white mb-2">Secure & Safe</h3>
                <p class="text-gray-400">Free SSL certificates and daily backups</p>
            </div>
            <div class="text-center">
                <div class="w-16 h-16 bg-green-600 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z" />
                    </svg>
                </div>
                <h3 class="text-lg font-semibold text-white mb-2">24/7 Support</h3>
                <p class="text-gray-400">Expert support whenever you need it</p>
            </div>
        </div>
    </div>
</div>
@endsection
