@extends('layouts.app')
@section('title', $product->name)
@section('content')
<div class="min-h-screen bg-gray-900 p-6">
    <div class="max-w-4xl mx-auto">
        <div class="mb-8">
            <a href="{{ route('client.dashboard') }}" class="text-blue-400 hover:text-blue-300 text-sm mb-4 inline-block">&larr; Back to Dashboard</a>
            <h1 class="text-3xl font-bold text-white mb-2">{{ $product->name }}</h1>
            <p class="text-gray-400">{{ $product->description }}</p>
        </div>

        <div class="bg-gray-800 border border-gray-700 rounded-xl p-6 mb-6">
            <h2 class="text-xl font-bold text-white mb-4">Product Details</h2>
            <div class="grid grid-cols-2 gap-4">
                <div>
                    <p class="text-gray-400 text-sm">Type</p>
                    <p class="text-white font-medium">{{ ucfirst($product->type) }}</p>
                </div>
                <div>
                    <p class="text-gray-400 text-sm">Status</p>
                    <p class="text-white font-medium">{{ $product->active ? 'Active' : 'Inactive' }}</p>
                </div>
            </div>
        </div>

        @if($product->pricing->count() > 0)
            <div class="bg-gray-800 border border-gray-700 rounded-xl p-6 mb-6">
                <h2 class="text-xl font-bold text-white mb-4">Pricing Plans</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    @foreach($product->pricing as $pricing)
                        <div class="bg-gray-900 border border-gray-700 rounded-lg p-4">
                            <div class="text-lg font-bold text-white">{{ ucfirst($pricing->billing_cycle) }}</div>
                            <div class="text-2xl font-bold text-blue-400 mt-2">{{ format_currency($pricing->price) }}</div>
                        </div>
                    @endforeach
                </div>
            </div>
        @endif

        <div class="flex justify-end">
            <a href="{{ route('client.services.index') }}" class="px-6 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-lg">Order Now</a>
        </div>
    </div>
</div>
@endsection