@extends('layouts.app')
@section('title', 'My Services')
@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <h1 class="text-3xl font-bold mb-6">My Services</h1>
    <div class="bg-white shadow rounded-lg p-6">
        @if($services->count())
            <table class="min-w-full">
                <thead>
                    <tr class="border-b">
                        <th class="text-left py-2">Service</th>
                        <th class="text-left py-2">Type</th>
                        <th class="text-left py-2">Price</th>
                        <th class="text-left py-2">Status</th>
                        <th class="text-left py-2">Next Due</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($services as $service)
                    <tr class="border-b">
                        <td class="py-2">{{ $service->name }}</td>
                        <td class="py-2">{{ $service->type }}</td>
                        <td class="py-2">{{ format_currency($service->price) }}</td>
                        <td class="py-2"><span class="px-2 py-1 text-xs rounded bg-green-100 text-green-800">{{ $service->status }}</span></td>
                        <td class="py-2">{{ $service->next_due_date?->format('M d, Y') ?? 'N/A' }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        @else
            <p class="text-gray-500">No services found</p>
        @endif
    </div>
</div>
@endsection
