@extends('layouts.app')
@section('title', 'Announcements')
@section('content')
<div class="min-h-screen bg-gray-900 p-6">
    <div class="max-w-4xl mx-auto">
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-white mb-2">Announcements</h1>
            <p class="text-gray-400">Stay updated with our latest news and updates</p>
        </div>

        <div class="space-y-6">
            @forelse($announcements as $announcement)
                <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
                    <div class="flex items-start justify-between">
                        <div class="flex-1">
                            <h3 class="text-xl font-bold text-white mb-2">{{ $announcement->title }}</h3>
                            <p class="text-gray-400 text-sm mb-4">{{ $announcement->published_at->format('F d, Y') }}</p>
                            <div class="text-gray-300">{{ $announcement->content }}</div>
                        </div>
                    </div>
                </div>
            @empty
                <div class="bg-gray-800 border border-gray-700 rounded-xl p-12 text-center">
                    <p class="text-gray-400">No announcements at this time</p>
                </div>
            @endforelse
        </div>
    </div>
</div>
@endsection