@extends('layouts.app')
@section('title', 'Downloads')
@section('content')
<div class="min-h-screen bg-gray-900 p-6">
    <div class="max-w-4xl mx-auto">
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-white mb-2">Downloads</h1>
            <p class="text-gray-400">Download helpful resources and tools</p>
        </div>

        <div class="space-y-4">
            @forelse($downloads as $download)
                <div class="bg-gray-800 border border-gray-700 rounded-xl p-6 flex items-center justify-between hover:border-blue-500 transition">
                    <div class="flex items-center space-x-4">
                        <div class="w-12 h-12 bg-blue-600 rounded-lg flex items-center justify-center">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M9 19l3 3m0 0l3-3m-3 3V10"></path>
                            </svg>
                        </div>
                        <div>
                            <h3 class="text-lg font-bold text-white">{{ $download->name }}</h3>
                            <p class="text-gray-400 text-sm">{{ $download->description }}</p>
                            <p class="text-gray-500 text-xs mt-1">{{ $download->file_size }} • Downloaded {{ $download->download_count }} times</p>
                        </div>
                    </div>
                    <button class="px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-lg">Download</button>
                </div>
            @empty
                <div class="bg-gray-800 border border-gray-700 rounded-xl p-12 text-center">
                    <p class="text-gray-400">No downloads available</p>
                </div>
            @endforelse
        </div>
    </div>
</div>
@endsection