@extends('layouts.app')
@section('title', 'Knowledgebase')
@section('content')
<div class="min-h-screen bg-gray-900 p-6">
    <div class="max-w-7xl mx-auto">
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-white mb-2">Knowledgebase</h1>
            <p class="text-gray-400">Find answers to common questions</p>
        </div>

        <!-- Search -->
        <div class="mb-8">
            <input type="text" placeholder="Search articles..." class="w-full px-4 py-3 bg-gray-800 border border-gray-700 rounded-lg text-white">
        </div>

        <!-- Categories -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            @forelse($categories as $category)
                <a href="#" class="bg-gray-800 border border-gray-700 rounded-xl p-6 hover:border-blue-500 transition">
                    <div class="w-12 h-12 bg-blue-600 rounded-lg flex items-center justify-center mb-4">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-bold text-white mb-2">{{ $category->name }}</h3>
                    <p class="text-gray-400 text-sm">{{ $category->articles_count }} articles</p>
                </a>
            @empty
                <div class="col-span-3 bg-gray-800 border border-gray-700 rounded-xl p-12 text-center">
                    <p class="text-gray-400">No categories available</p>
                </div>
            @endforelse
        </div>
    </div>
</div>
@endsection