@extends('layouts.app')
@section('title', 'My Tickets')
@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-3xl font-bold">My Tickets</h1>
        <a href="{{ route('client.tickets.create') }}" class="px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-700">New Ticket</a>
    </div>
    <div class="bg-white shadow rounded-lg p-6">
        @if($tickets->count())
            <table class="min-w-full">
                <thead>
                    <tr class="border-b">
                        <th class="text-left py-2">Subject</th>
                        <th class="text-left py-2">Status</th>
                        <th class="text-left py-2">Priority</th>
                        <th class="text-left py-2">Created</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($tickets as $ticket)
                    <tr class="border-b">
                        <td class="py-2">{{ $ticket->subject }}</td>
                        <td class="py-2"><span class="px-2 py-1 text-xs rounded bg-blue-100 text-blue-800">{{ $ticket->status }}</span></td>
                        <td class="py-2"><span class="px-2 py-1 text-xs rounded bg-yellow-100 text-yellow-800">{{ $ticket->priority }}</span></td>
                        <td class="py-2">{{ $ticket->created_at->format('M d, Y') }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        @else
            <p class="text-gray-500">No tickets found</p>
        @endif
    </div>
</div>
@endsection
