@extends('emails.layout')

@section('content')
    <h2>Welcome to {{ config('app.name') }}!</h2>
    
    <p>Hello {{ $user->name }},</p>
    
    <p>Thank you for registering with {{ config('app.name') }}. Your account has been successfully created.</p>
    
    <table style="width: 100%; border-collapse: collapse; margin: 20px 0;">
        <tr>
            <td><strong>Email:</strong></td>
            <td>{{ $user->email }}</td>
        </tr>
        <tr>
            <td><strong>Account Type:</strong></td>
            <td>{{ ucfirst($user->role) }}</td>
        </tr>
    </table>
    
    <p style="text-align: center; margin: 30px 0;">
        <a href="{{ route('client.dashboard') }}" class="button">
            Go to Dashboard
        </a>
    </p>
    
    <p>If you have any questions or need assistance, please don't hesitate to contact our support team.</p>
    
    <p>Best regards,<br>The {{ config('app.name') }} Team</p>
@endsection
