<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="dark">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ $site_name ?? config('app.name') }} - Maintenance Mode</title>
    @vite(['resources/css/app.css'])
</head>
<body class="bg-gray-900 text-gray-100">
    <div class="min-h-screen flex items-center justify-center p-6">
        <div class="max-w-2xl w-full">
            <div class="bg-gray-800 border border-gray-700 rounded-xl p-8 text-center">
                <div class="w-20 h-20 bg-yellow-500/10 rounded-xl flex items-center justify-center mx-auto mb-6">
                    <svg class="w-10 h-10 text-yellow-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                    </svg>
                </div>
                <h1 class="text-3xl font-bold text-white mb-4">We'll Be Right Back!</h1>
                <p class="text-gray-400 mb-6">
                    {{ $message ?: ($site_name ?? config('app.name')) . ' is currently undergoing scheduled maintenance. We\'ll be back online shortly.' }}
                </p>
                <p class="text-sm text-gray-500">Thank you for your patience.</p>
            </div>
        </div>
    </div>
</body>
</html>
