<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" {{ config('auth-ui.dark_mode') ? 'class=dark' : '' }}>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ config('app.name', 'BillingCS') }} - @yield('title')</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <style>
        @keyframes float {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-20px) rotate(5deg); }
        }
        @keyframes glow {
            0%, 100% { opacity: 0.3; }
            50% { opacity: 0.8; }
        }
        @keyframes slideText {
            0% { transform: translateY(0); opacity: 1; }
            25% { transform: translateY(0); opacity: 1; }
            30% { transform: translateY(-100%); opacity: 0; }
            31% { transform: translateY(100%); opacity: 0; }
            35% { transform: translateY(0); opacity: 1; }
            100% { transform: translateY(0); opacity: 1; }
        }
        .animate-float {
            animation: float 6s ease-in-out infinite;
        }
        .animate-glow {
            animation: glow 3s ease-in-out infinite;
        }
        .tech-word {
            animation: slideText 12s ease-in-out infinite;
        }
    </style>
</head>
<body class="bg-gray-900 text-gray-100 antialiased">
    <div class="min-h-screen flex">
        <!-- Left Sidebar - Tech Themed (Hidden on mobile) -->
        <div class="hidden lg:flex lg:w-1/2 relative overflow-hidden bg-gradient-to-br from-gray-900 via-blue-900 to-purple-900">
            <!-- Animated Background Elements -->
            <div class="absolute inset-0 overflow-hidden">
                <!-- Glowing orbs -->
                <div class="absolute top-20 left-20 w-64 h-64 bg-blue-500 rounded-full mix-blend-multiply filter blur-3xl opacity-30 animate-float"></div>
                <div class="absolute bottom-20 right-20 w-96 h-96 bg-purple-500 rounded-full mix-blend-multiply filter blur-3xl opacity-20 animate-float" style="animation-delay: 2s;"></div>
                <div class="absolute top-1/2 left-1/3 w-48 h-48 bg-cyan-500 rounded-full mix-blend-multiply filter blur-3xl opacity-25 animate-float" style="animation-delay: 4s;"></div>
                
                <!-- Grid pattern overlay -->
                <div class="absolute inset-0" style="background-image: radial-gradient(circle at 2px 2px, rgba(255, 255, 255, 0.03) 1px, transparent 0); background-size: 40px 40px;"></div>
                
                <!-- Illuminated geometric shapes -->
                <div class="absolute top-40 right-40 w-32 h-32 border-2 border-blue-400/30 rotate-45 animate-glow"></div>
                <div class="absolute bottom-40 left-40 w-24 h-24 border-2 border-purple-400/30 rotate-12 animate-glow" style="animation-delay: 1.5s;"></div>
                <div class="absolute top-1/3 right-1/4 w-16 h-16 border-2 border-cyan-400/30 rotate-45 animate-glow" style="animation-delay: 3s;"></div>
            </div>
            
            <!-- Content -->
            <div class="relative z-10 flex flex-col justify-center items-center w-full p-12">
                <!-- Logo/Brand -->
                <div class="mb-12">
                    <div class="flex items-center space-x-3">
                        <div class="w-16 h-16 bg-gradient-to-br from-blue-500 to-purple-600 rounded-xl flex items-center justify-center shadow-2xl">
                            <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                            </svg>
                        </div>
                        <div>
                            <h1 class="text-4xl font-bold text-white">{{ config('app.name', 'BillingCS') }}</h1>
                            <p class="text-blue-300 text-sm">Next-Gen Hosting Solutions</p>
                        </div>
                    </div>
                </div>
                
                <!-- Illuminated Image/Icon Area -->
                <div class="relative mb-12">
                    <div class="w-80 h-80 relative">
                        <!-- Glowing backdrop -->
                        <div class="absolute inset-0 bg-gradient-to-br from-blue-500/20 to-purple-500/20 rounded-3xl blur-xl"></div>
                        
                        <!-- Server illustration -->
                        <svg viewBox="0 0 400 400" class="relative w-full h-full drop-shadow-2xl">
                            <!-- Circuit board pattern -->
                            <defs>
                                <linearGradient id="serverGlow" x1="0%" y1="0%" x2="100%" y2="100%">
                                    <stop offset="0%" style="stop-color:#3B82F6;stop-opacity:0.8" />
                                    <stop offset="100%" style="stop-color:#8B5CF6;stop-opacity:0.8" />
                                </linearGradient>
                            </defs>
                            
                            <!-- Server stack -->
                            <g transform="translate(80, 100)">
                                <!-- Top server -->
                                <rect x="0" y="0" width="240" height="50" rx="8" fill="url(#serverGlow)" opacity="0.6" class="animate-pulse" style="animation-duration: 3s;"/>
                                <circle cx="30" cy="25" r="6" fill="#10B981" class="animate-pulse"/>
                                <circle cx="50" cy="25" r="6" fill="#10B981" class="animate-pulse" style="animation-delay: 0.3s;"/>
                                <circle cx="70" cy="25" r="6" fill="#F59E0B" class="animate-pulse" style="animation-delay: 0.6s;"/>
                                
                                <!-- Middle server -->
                                <rect x="0" y="70" width="240" height="50" rx="8" fill="url(#serverGlow)" opacity="0.7" class="animate-pulse" style="animation-duration: 3s; animation-delay: 0.5s;"/>
                                <circle cx="30" cy="95" r="6" fill="#10B981" class="animate-pulse" style="animation-delay: 0.2s;"/>
                                <circle cx="50" cy="95" r="6" fill="#10B981" class="animate-pulse" style="animation-delay: 0.5s;"/>
                                <circle cx="70" cy="95" r="6" fill="#10B981" class="animate-pulse" style="animation-delay: 0.8s;"/>
                                
                                <!-- Bottom server -->
                                <rect x="0" y="140" width="240" height="50" rx="8" fill="url(#serverGlow)" opacity="0.8" class="animate-pulse" style="animation-duration: 3s; animation-delay: 1s;"/>
                                <circle cx="30" cy="165" r="6" fill="#10B981" class="animate-pulse" style="animation-delay: 0.4s;"/>
                                <circle cx="50" cy="165" r="6" fill="#F59E0B" class="animate-pulse" style="animation-delay: 0.7s;"/>
                                <circle cx="70" cy="165" r="6" fill="#10B981" class="animate-pulse" style="animation-delay: 1s;"/>
                            </g>
                        </svg>
                    </div>
                </div>
                
                <!-- Rotating Tech Words/Quotes -->
                <div class="text-center max-w-lg">
                    <div class="relative h-32 overflow-hidden">
                        <div class="absolute inset-0 flex items-center justify-center">
                            <div class="tech-word text-3xl font-bold bg-gradient-to-r from-blue-400 via-purple-400 to-cyan-400 bg-clip-text text-transparent">
                                Powering Innovation
                            </div>
                        </div>
                    </div>
                    <p class="text-gray-300 text-lg mt-4">
                        Join thousands of developers and businesses who trust us with their hosting needs.
                    </p>
                </div>
                
                <!-- Feature highlights -->
                <div class="mt-12 grid grid-cols-3 gap-6 w-full max-w-md">
                    <div class="text-center">
                        <div class="text-3xl font-bold text-blue-400 mb-1">99.9%</div>
                        <div class="text-sm text-gray-400">Uptime</div>
                    </div>
                    <div class="text-center">
                        <div class="text-3xl font-bold text-purple-400 mb-1">24/7</div>
                        <div class="text-sm text-gray-400">Support</div>
                    </div>
                    <div class="text-center">
                        <div class="text-3xl font-bold text-cyan-400 mb-1">10K+</div>
                        <div class="text-sm text-gray-400">Users</div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Right Side - Auth Form -->
        <div class="w-full lg:w-1/2 flex items-center justify-center p-6 sm:p-12 bg-gray-900">
            <div class="w-full max-w-md">
                <!-- Mobile logo (visible only on small screens) -->
                <div class="lg:hidden mb-8 text-center">
                    <div class="inline-flex items-center space-x-2">
                        <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-purple-600 rounded-lg flex items-center justify-center">
                            <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                            </svg>
                        </div>
                        <h1 class="text-2xl font-bold text-white">{{ config('app.name', 'BillingCS') }}</h1>
                    </div>
                </div>
                
                @yield('content')
            </div>
        </div>
    </div>
    
    <script>
        // Rotating tech quotes from configuration
        document.addEventListener('DOMContentLoaded', function() {
            const quotes = @json(config('auth-ui.tech_quotes'));
            let currentQuote = 0;
            let quoteInterval = null;
            const quoteElement = document.querySelector('.tech-word');
            
            if (quoteElement && quotes.length > 0) {
                quoteInterval = setInterval(() => {
                    currentQuote = (currentQuote + 1) % quotes.length;
                    quoteElement.textContent = quotes[currentQuote];
                }, 4000);
            }
            
            // Clear interval on page unload to prevent memory leaks
            window.addEventListener('beforeunload', function() {
                if (quoteInterval) {
                    clearInterval(quoteInterval);
                }
            });
        });
    </script>
</body>
</html>
