@extends('layouts.app')

@section('title', 'Welcome')

@section('content')
<style>
.animate-bounce-slow {
    animation-delay: var(--animation-delay, 0s);
}
</style>
<!-- Hero Section with Animated Background -->
<div class="relative bg-gradient-to-br from-gray-900 via-blue-900 to-purple-900 py-24 lg:py-32 overflow-hidden">
    <!-- Animated Background Elements -->
    <div class="absolute inset-0 overflow-hidden">
        <div class="absolute -top-40 -right-40 w-80 h-80 bg-blue-500 rounded-full mix-blend-multiply filter blur-xl opacity-20 animate-bounce-slow"></div>
        <div class="absolute -bottom-40 -left-40 w-80 h-80 bg-purple-500 rounded-full mix-blend-multiply filter blur-xl opacity-20 animate-bounce-slow" style="--animation-delay: 2s;"></div>
        <!-- Grid pattern overlay -->
        <div class="absolute inset-0" style="background-image: radial-gradient(circle at 2px 2px, rgba(255, 255, 255, 0.05) 1px, transparent 0); background-size: 40px 40px;"></div>
    </div>
    
    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <!-- Left Content -->
            <div class="text-center lg:text-left">
                <h1 class="text-5xl md:text-6xl lg:text-7xl font-bold text-white mb-6 animate-fade-in-down leading-tight">
                    Premium Web <span class="bg-gradient-to-r from-blue-400 to-purple-400 bg-clip-text text-transparent">Hosting</span> Solutions
                </h1>
                <p class="text-xl md:text-2xl text-gray-300 mb-8 max-w-2xl mx-auto lg:mx-0 animate-fade-in-up leading-relaxed" style="animation-delay: 0.2s;">
                    Lightning-fast, secure, and reliable hosting with 99.9% uptime guarantee. Start your online journey today!
                </p>
                
                <!-- CTA Buttons -->
                <div class="flex flex-col sm:flex-row gap-4 justify-center lg:justify-start mb-8 animate-fade-in-up" style="animation-delay: 0.3s;">
                    <a href="{{ route('register') }}" class="inline-flex items-center justify-center px-8 py-4 bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700 text-white font-bold text-lg rounded-lg transition shadow-xl hover:shadow-2xl transform hover:-translate-y-1">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                        </svg>
                        Get Started Now
                    </a>
                    <a href="#pricing" class="inline-flex items-center justify-center px-8 py-4 bg-white/10 backdrop-blur-sm border-2 border-white/30 hover:bg-white/20 text-white font-semibold text-lg rounded-lg transition">
                        View Plans
                        <svg class="w-5 h-5 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                        </svg>
                    </a>
                </div>
            </div>
            
            <!-- Right Content - 3D Server Illustration -->
            <div class="relative animate-fade-in-up" style="animation-delay: 0.4s;">
                <!-- Static 3D Server SVG Illustration -->
                <div class="relative w-full h-96 lg:h-[500px]">
                    <svg viewBox="0 0 400 400" class="w-full h-full drop-shadow-2xl" xmlns="http://www.w3.org/2000/svg">
                        <!-- Server Stack -->
                        <g class="server-stack">
                            <!-- Server 1 (Top) -->
                            <g transform="translate(100, 80)">
                                <!-- Server front face -->
                                <rect x="0" y="0" width="200" height="40" fill="url(#serverGradient1)" stroke="#3B82F6" stroke-width="2" rx="4"/>
                                <!-- Server side face (3D effect) -->
                                <path d="M 200 0 L 220 -15 L 220 25 L 200 40 Z" fill="url(#sideGradient1)" stroke="#3B82F6" stroke-width="1"/>
                                <!-- Server top face (3D effect) -->
                                <path d="M 0 0 L 20 -15 L 220 -15 L 200 0 Z" fill="url(#topGradient1)" stroke="#3B82F6" stroke-width="1"/>
                                <!-- LED indicators -->
                                <circle cx="20" cy="20" r="4" fill="#10B981" class="animate-pulse"/>
                                <circle cx="35" cy="20" r="4" fill="#10B981" class="animate-pulse" style="animation-delay: 0.3s;"/>
                                <circle cx="50" cy="20" r="4" fill="#F59E0B" class="animate-pulse" style="animation-delay: 0.6s;"/>
                                <!-- Vent lines -->
                                <line x1="170" y1="12" x2="185" y2="12" stroke="#4B5563" stroke-width="2"/>
                                <line x1="170" y1="20" x2="185" y2="20" stroke="#4B5563" stroke-width="2"/>
                                <line x1="170" y1="28" x2="185" y2="28" stroke="#4B5563" stroke-width="2"/>
                            </g>
                            
                            <!-- Server 2 (Middle) -->
                            <g transform="translate(100, 140)">
                                <rect x="0" y="0" width="200" height="40" fill="url(#serverGradient2)" stroke="#8B5CF6" stroke-width="2" rx="4"/>
                                <path d="M 200 0 L 220 -15 L 220 25 L 200 40 Z" fill="url(#sideGradient2)" stroke="#8B5CF6" stroke-width="1"/>
                                <path d="M 0 0 L 20 -15 L 220 -15 L 200 0 Z" fill="url(#topGradient2)" stroke="#8B5CF6" stroke-width="1"/>
                                <circle cx="20" cy="20" r="4" fill="#10B981" class="animate-pulse" style="animation-delay: 0.2s;"/>
                                <circle cx="35" cy="20" r="4" fill="#10B981" class="animate-pulse" style="animation-delay: 0.5s;"/>
                                <circle cx="50" cy="20" r="4" fill="#10B981" class="animate-pulse" style="animation-delay: 0.8s;"/>
                                <line x1="170" y1="12" x2="185" y2="12" stroke="#4B5563" stroke-width="2"/>
                                <line x1="170" y1="20" x2="185" y2="20" stroke="#4B5563" stroke-width="2"/>
                                <line x1="170" y1="28" x2="185" y2="28" stroke="#4B5563" stroke-width="2"/>
                            </g>
                            
                            <!-- Server 3 (Bottom) -->
                            <g transform="translate(100, 200)">
                                <rect x="0" y="0" width="200" height="40" fill="url(#serverGradient3)" stroke="#EC4899" stroke-width="2" rx="4"/>
                                <path d="M 200 0 L 220 -15 L 220 25 L 200 40 Z" fill="url(#sideGradient3)" stroke="#EC4899" stroke-width="1"/>
                                <path d="M 0 0 L 20 -15 L 220 -15 L 200 0 Z" fill="url(#topGradient3)" stroke="#EC4899" stroke-width="1"/>
                                <circle cx="20" cy="20" r="4" fill="#10B981" class="animate-pulse" style="animation-delay: 0.4s;"/>
                                <circle cx="35" cy="20" r="4" fill="#F59E0B" class="animate-pulse" style="animation-delay: 0.7s;"/>
                                <circle cx="50" cy="20" r="4" fill="#10B981" class="animate-pulse" style="animation-delay: 1s;"/>
                                <line x1="170" y1="12" x2="185" y2="12" stroke="#4B5563" stroke-width="2"/>
                                <line x1="170" y1="20" x2="185" y2="20" stroke="#4B5563" stroke-width="2"/>
                                <line x1="170" y1="28" x2="185" y2="28" stroke="#4B5563" stroke-width="2"/>
                            </g>
                        </g>
                        
                        <!-- Connection Lines (Data Flow) -->
                        <g class="connection-lines" opacity="0.6">
                            <path d="M 50 280 Q 150 300 200 280" stroke="#3B82F6" stroke-width="2" fill="none" stroke-dasharray="5,5" class="animate-pulse"/>
                            <path d="M 350 280 Q 250 300 200 280" stroke="#8B5CF6" stroke-width="2" fill="none" stroke-dasharray="5,5" class="animate-pulse" style="animation-delay: 0.5s;"/>
                        </g>
                        
                        <!-- Floating Elements -->
                        <g class="floating-elements">
                            <!-- Cloud -->
                            <g transform="translate(40, 40)" opacity="0.4">
                                <circle cx="0" cy="0" r="15" fill="#60A5FA"/>
                                <circle cx="20" cy="0" r="20" fill="#60A5FA"/>
                                <circle cx="40" cy="0" r="15" fill="#60A5FA"/>
                                <rect x="-15" y="0" width="70" height="15" fill="#60A5FA"/>
                            </g>
                            
                            <!-- Shield -->
                            <g transform="translate(320, 50)" opacity="0.4">
                                <path d="M 0 0 L -15 5 L -15 25 Q -15 35 0 40 Q 15 35 15 25 L 15 5 Z" fill="#10B981"/>
                                <path d="M -5 15 L 0 20 L 10 10" stroke="white" stroke-width="2" fill="none"/>
                            </g>
                        </g>
                        
                        <!-- Gradients -->
                        <defs>
                            <linearGradient id="serverGradient1" x1="0%" y1="0%" x2="0%" y2="100%">
                                <stop offset="0%" style="stop-color:#3B82F6;stop-opacity:0.9" />
                                <stop offset="100%" style="stop-color:#1E40AF;stop-opacity:0.9" />
                            </linearGradient>
                            <linearGradient id="sideGradient1" x1="0%" y1="0%" x2="100%" y2="0%">
                                <stop offset="0%" style="stop-color:#1E40AF;stop-opacity:0.8" />
                                <stop offset="100%" style="stop-color:#1E3A8A;stop-opacity:0.8" />
                            </linearGradient>
                            <linearGradient id="topGradient1" x1="0%" y1="0%" x2="0%" y2="100%">
                                <stop offset="0%" style="stop-color:#60A5FA;stop-opacity:0.9" />
                                <stop offset="100%" style="stop-color:#3B82F6;stop-opacity:0.9" />
                            </linearGradient>
                            
                            <linearGradient id="serverGradient2" x1="0%" y1="0%" x2="0%" y2="100%">
                                <stop offset="0%" style="stop-color:#8B5CF6;stop-opacity:0.9" />
                                <stop offset="100%" style="stop-color:#6D28D9;stop-opacity:0.9" />
                            </linearGradient>
                            <linearGradient id="sideGradient2" x1="0%" y1="0%" x2="100%" y2="0%">
                                <stop offset="0%" style="stop-color:#6D28D9;stop-opacity:0.8" />
                                <stop offset="100%" style="stop-color:#5B21B6;stop-opacity:0.8" />
                            </linearGradient>
                            <linearGradient id="topGradient2" x1="0%" y1="0%" x2="0%" y2="100%">
                                <stop offset="0%" style="stop-color:#A78BFA;stop-opacity:0.9" />
                                <stop offset="100%" style="stop-color:#8B5CF6;stop-opacity:0.9" />
                            </linearGradient>
                            
                            <linearGradient id="serverGradient3" x1="0%" y1="0%" x2="0%" y2="100%">
                                <stop offset="0%" style="stop-color:#EC4899;stop-opacity:0.9" />
                                <stop offset="100%" style="stop-color:#BE185D;stop-opacity:0.9" />
                            </linearGradient>
                            <linearGradient id="sideGradient3" x1="0%" y1="0%" x2="100%" y2="0%">
                                <stop offset="0%" style="stop-color:#BE185D;stop-opacity:0.8" />
                                <stop offset="100%" style="stop-color:#9F1239;stop-opacity:0.8" />
                            </linearGradient>
                            <linearGradient id="topGradient3" x1="0%" y1="0%" x2="0%" y2="100%">
                                <stop offset="0%" style="stop-color:#F472B6;stop-opacity:0.9" />
                                <stop offset="100%" style="stop-color:#EC4899;stop-opacity:0.9" />
                            </linearGradient>
                        </defs>
                    </svg>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Domain Search Section -->
<div class="relative py-16 bg-gray-800 border-y border-gray-700">
    <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-8">
            <h2 class="text-3xl md:text-4xl font-bold text-white mb-4">Find Your Perfect Domain</h2>
            <p class="text-lg text-gray-400">Search for available domains and start your online presence today</p>
        </div>
        
        <!-- Domain Search with Animation -->
        <div class="animate-fade-in-up" x-data="{
            searching: false,
            domain: '',
            result: null,
            error: null,
            async searchDomain() {
                if (!this.domain) return;
                
                this.searching = true;
                this.result = null;
                this.error = null;
                
                try {
                    // Set the domain check URL using Blade, or empty string if route does not exist
                    const domainCheckUrl = @if(Route::has('domain.check')) '{{ route('domain.check') }}' @else '' @endif;
                    if (!domainCheckUrl) {
                        this.error = "Domain check route is not defined. Please contact the administrator.";
                        this.searching = false;
                        return;
                    }
                    const response = await fetch(domainCheckUrl, {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '{{ csrf_token() }}'
                        },
                        body: JSON.stringify({ domain: this.domain })
                    });
                    
                    const data = await response.json();
                    
                    if (data.success) {
                        this.result = data;
                    } else {
                        this.error = data.message;
                    }
                } catch (err) {
                    this.error = 'An error occurred. Please try again.';
                }
                
                this.searching = false;
            }
        }">
            <form @submit.prevent="searchDomain()" class="flex flex-col md:flex-row gap-4 mb-6">
                <input 
                    type="text" 
                    x-model="domain"
                    placeholder="yourdomain.com" 
                    class="flex-1 px-6 py-5 bg-gray-900 border-2 border-gray-700 focus:border-blue-500 rounded-lg text-white placeholder-gray-500 focus:outline-none transition text-lg"
                >
                <button 
                    type="submit" 
                    class="px-10 py-5 bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700 text-white font-bold rounded-lg transition shadow-lg hover:shadow-xl transform hover:-translate-y-0.5 text-lg disabled:opacity-50 disabled:cursor-not-allowed"
                    :disabled="searching"
                >
                    <span x-show="!searching" class="flex items-center justify-center">
                        <svg class="w-6 h-6 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                        </svg>
                        Search
                    </span>
                    <span x-show="searching" class="flex items-center justify-center">
                        <svg class="animate-spin h-6 w-6 mr-2" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                        </svg>
                        Searching...
                    </span>
                </button>
            </form>
            
            <!-- Search Results -->
            <div x-show="result" 
                 x-transition:enter="transition ease-out duration-300"
                 x-transition:enter-start="opacity-0 transform scale-95"
                 x-transition:enter-end="opacity-100 transform scale-100"
                 class="mb-6">
                <!-- Available Domain -->
                <div x-show="result && result.available" class="bg-green-900/30 border-2 border-green-500 rounded-lg p-6">
                    <div class="flex items-center justify-between flex-wrap gap-4">
                        <div class="flex items-center">
                            <svg class="w-8 h-8 text-green-500 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <div>
                                <h3 class="text-2xl font-bold text-white" x-text="result ? result.domain : ''"></h3>
                                <p class="text-green-400">Great news! This domain is available!</p>
                            </div>
                        </div>
                        <div class="text-right">
                            <div class="text-3xl font-bold text-white" x-text="result && result.pricing ? '$' + result.pricing.register : ''"></div>
                            <div class="text-sm text-gray-400">per year</div>
                            @if (Route::has('cart.add.domain'))
                                <form action="{{ route('cart.add.domain') }}" method="POST" class="mt-2" onsubmit="return validateDomainInput(this);">
                                    @csrf
                                    <input type="hidden" name="domain" x-bind:value="result ? result.domain : ''" id="domain-input">
                                    <button type="submit" class="px-6 py-2 bg-green-600 hover:bg-green-700 text-white font-semibold rounded-lg transition">
                                        Add to Cart
                                    </button>
                                </form>
                                <script>
                                function validateDomainInput(form) {
                                    var domain = form.querySelector('input[name=\"domain\"]').value;
                                    // Simple regex for domain validation (does not cover all cases)
                                    var domainPattern = /^(?!\-)(?:[a-zA-Z0-9\-]{1,63}\.)+[a-zA-Z]{2,}$/;
                                    if (!domain || !domainPattern.test(domain)) {
                                        alert('Please enter a valid domain name.');
                                        return false;
                                    }
                                    return true;
                                }
                                </script>
                            @else
                                <div class="mt-2 text-red-400">
                                    Cart functionality is not available at this time.
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
                
                <!-- Unavailable Domain -->
                <div x-show="result && !result.available" class="bg-red-900/30 border-2 border-red-500 rounded-lg p-6">
                    <div class="flex items-center">
                        <svg class="w-8 h-8 text-red-500 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        <div>
                            <h3 class="text-2xl font-bold text-white" x-text="result ? result.domain : ''"></h3>
                            <p class="text-red-400">Sorry, this domain is already taken.</p>
                            <p class="text-sm text-gray-400 mt-1">Try a different name or extension.</p>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Error Message -->
            <div x-show="error" 
                 x-transition
                 class="mb-6 bg-orange-900/30 border border-orange-500 rounded-lg p-4">
                <div class="flex items-center">
                    <svg class="w-6 h-6 text-orange-500 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                    </svg>
                    <p class="text-orange-300" x-text="error"></p>
                </div>
            </div>
            
            <!-- Popular TLDs -->
            <div class="flex flex-wrap gap-4 justify-center">
                {{-- $defaultPrices is now expected to be passed from the controller --}}
                
                
                
                
                
                
                
                @foreach(['.com', '.net', '.org', '.io'] as $tld)
                    @php
                        $pricing = isset($popularTlds) && $popularTlds->has($tld) ? $popularTlds->get($tld) : null;
                        $price = $pricing ? number_format($pricing->register_price, 2) : $defaultPrices[$tld];
                    @endphp
                    <div class="px-6 py-3 bg-gray-900 border border-gray-700 rounded-lg text-center hover:border-blue-500 transition cursor-pointer"
                         @click="domain = domain.replace(/\.[^.]*$/, '') + '{{ $tld }}'; searchDomain()">
                        <div class="text-sm text-gray-400">{{ $tld }}</div>
                        <div class="text-lg font-bold text-white">${{ $price }}<span class="text-sm text-gray-400">/yr</span></div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</div>

<!-- Features Section with Scroll Animations -->
<div class="py-20 bg-gray-900" x-data="{ inView: false }" x-intersect="inView = true">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="text-4xl font-bold text-white mb-4" 
                :class="{ 'animate-fade-in-up': inView }">
                Why Choose Us?
            </h2>
            <p class="text-xl text-gray-400" 
               :class="{ 'animate-fade-in-up': inView }"
               style="animation-delay: 0.1s;">
                Experience the difference with our premium hosting solutions
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div class="bg-gray-800 p-8 rounded-xl border border-gray-700 hover:border-blue-500 transition-all duration-300 transform hover:-translate-y-2 hover:shadow-2xl group"
                 :class="{ 'animate-fade-in-up': inView }"
                 style="animation-delay: 0.2s;">
                <div class="w-16 h-16 bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300">
                    <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                    </svg>
                </div>
                <h3 class="text-2xl font-semibold text-white mb-3">Lightning Fast</h3>
                <p class="text-gray-400 leading-relaxed">SSD-powered hosting with CDN integration delivers exceptional speed and performance for your websites.</p>
            </div>
            
            <div class="bg-gray-800 p-8 rounded-xl border border-gray-700 hover:border-purple-500 transition-all duration-300 transform hover:-translate-y-2 hover:shadow-2xl group"
                 :class="{ 'animate-fade-in-up': inView }"
                 style="animation-delay: 0.3s;">
                <div class="w-16 h-16 bg-gradient-to-br from-purple-500 to-purple-600 rounded-xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300">
                    <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                    </svg>
                </div>
                <h3 class="text-2xl font-semibold text-white mb-3">Secure & Reliable</h3>
                <p class="text-gray-400 leading-relaxed">Free SSL certificates, advanced DDoS protection, and automated daily backups keep your data safe.</p>
            </div>
            
            <div class="bg-gray-800 p-8 rounded-xl border border-gray-700 hover:border-green-500 transition-all duration-300 transform hover:-translate-y-2 hover:shadow-2xl group"
                 :class="{ 'animate-fade-in-up': inView }"
                 style="animation-delay: 0.4s;">
                <div class="w-16 h-16 bg-gradient-to-br from-green-500 to-green-600 rounded-xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300">
                    <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z"></path>
                    </svg>
                </div>
                <h3 class="text-2xl font-semibold text-white mb-3">24/7 Expert Support</h3>
                <p class="text-gray-400 leading-relaxed">Our dedicated support team is always available to help you succeed with round-the-clock assistance.</p>
            </div>
        </div>
    </div>
</div>

<!-- Hosting Plans with Animation -->
<div class="py-20 bg-gray-800" x-data="{ inView: false }" x-intersect="inView = true" id="pricing">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="text-4xl font-bold text-white mb-4"
                :class="{ 'animate-fade-in-up': inView }">
                Flexible Hosting Plans
            </h2>
            <p class="text-xl text-gray-400"
               :class="{ 'animate-fade-in-up': inView }"
               style="animation-delay: 0.1s;">
                Choose the perfect plan that grows with your business
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <!-- Starter Plan -->
            <div class="bg-gray-900 rounded-xl border border-gray-700 p-8 hover:border-blue-500 transition-all duration-300 transform hover:-translate-y-2 hover:shadow-2xl"
                 :class="{ 'animate-fade-in-up': inView }"
                 style="animation-delay: 0.2s;">
                <div class="text-center mb-8">
                    <h3 class="text-2xl font-bold text-white mb-4">Starter</h3>
                    <div class="mb-2">
                        <span class="text-5xl font-bold text-blue-500">$4.99</span>
                    </div>
                    <span class="text-gray-400">per month</span>
                </div>
                <ul class="space-y-4 mb-8">
                    <li class="flex items-center text-gray-300">
                        <svg class="w-5 h-5 text-green-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span>10 GB SSD Storage</span>
                    </li>
                    <li class="flex items-center text-gray-300">
                        <svg class="w-5 h-5 text-green-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span>100 GB Bandwidth</span>
                    </li>
                    <li class="flex items-center text-gray-300">
                        <svg class="w-5 h-5 text-green-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span>Free SSL Certificate</span>
                    </li>
                    <li class="flex items-center text-gray-300">
                        <svg class="w-5 h-5 text-green-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span>1 Website</span>
                    </li>
                    <li class="flex items-center text-gray-300">
                        <svg class="w-5 h-5 text-green-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span>24/7 Support</span>
                    </li>
                </ul>
                <a href="{{ route('register') }}" class="block w-full py-3 text-center bg-gray-800 hover:bg-gray-700 text-white font-semibold rounded-lg transition border border-gray-700 hover:border-blue-500">
                    Get Started
                </a>
            </div>

            <!-- Professional Plan (Featured) -->
            <div class="relative bg-gradient-to-br from-blue-600 to-purple-600 rounded-xl p-8 transform md:scale-105 shadow-2xl"
                 :class="{ 'animate-scale-in': inView }"
                 style="animation-delay: 0.3s;">
                <div class="absolute -top-4 left-1/2 transform -translate-x-1/2">
                    <span class="inline-block bg-yellow-400 text-gray-900 px-6 py-2 rounded-full font-bold text-sm shadow-lg">
                        MOST POPULAR
                    </span>
                </div>
                <div class="text-center mb-8 mt-4">
                    <h3 class="text-2xl font-bold text-white mb-4">Professional</h3>
                    <div class="mb-2">
                        <span class="text-5xl font-bold text-white">$9.99</span>
                    </div>
                    <span class="text-gray-100">per month</span>
                </div>
                <ul class="space-y-4 mb-8">
                    <li class="flex items-center text-white">
                        <svg class="w-5 h-5 text-yellow-300 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span>50 GB SSD Storage</span>
                    </li>
                    <li class="flex items-center text-white">
                        <svg class="w-5 h-5 text-yellow-300 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span>Unlimited Bandwidth</span>
                    </li>
                    <li class="flex items-center text-white">
                        <svg class="w-5 h-5 text-yellow-300 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span>Free SSL & Daily Backups</span>
                    </li>
                    <li class="flex items-center text-white">
                        <svg class="w-5 h-5 text-yellow-300 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span>10 Websites</span>
                    </li>
                    <li class="flex items-center text-white">
                        <svg class="w-5 h-5 text-yellow-300 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span>Priority Support</span>
                    </li>
                </ul>
                <a href="{{ route('register') }}" class="block w-full py-3 text-center bg-white hover:bg-gray-100 text-blue-600 font-semibold rounded-lg transition shadow-lg hover:shadow-xl transform hover:-translate-y-0.5">
                    Get Started
                </a>
            </div>

            <!-- Business Plan -->
            <div class="bg-gray-900 rounded-xl border border-gray-700 p-8 hover:border-purple-500 transition-all duration-300 transform hover:-translate-y-2 hover:shadow-2xl"
                 :class="{ 'animate-fade-in-up': inView }"
                 style="animation-delay: 0.4s;">
                <div class="text-center mb-8">
                    <h3 class="text-2xl font-bold text-white mb-4">Business</h3>
                    <div class="mb-2">
                        <span class="text-5xl font-bold text-purple-500">$19.99</span>
                    </div>
                    <span class="text-gray-400">per month</span>
                </div>
                <ul class="space-y-4 mb-8">
                    <li class="flex items-center text-gray-300">
                        <svg class="w-5 h-5 text-green-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span>100 GB SSD Storage</span>
                    </li>
                    <li class="flex items-center text-gray-300">
                        <svg class="w-5 h-5 text-green-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span>Unlimited Bandwidth</span>
                    </li>
                    <li class="flex items-center text-gray-300">
                        <svg class="w-5 h-5 text-green-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span>Free SSL & Daily Backups</span>
                    </li>
                    <li class="flex items-center text-gray-300">
                        <svg class="w-5 h-5 text-green-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span>Unlimited Websites</span>
                    </li>
                    <li class="flex items-center text-gray-300">
                        <svg class="w-5 h-5 text-green-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span>Premium Support</span>
                    </li>
                </ul>
                <a href="{{ route('register') }}" class="block w-full py-3 text-center bg-gray-800 hover:bg-gray-700 text-white font-semibold rounded-lg transition border border-gray-700 hover:border-purple-500">
                    Get Started
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Hosting Types Summary Section -->
<div class="py-20 bg-gray-900" x-data="{ inView: false }" x-intersect="inView = true">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="text-4xl font-bold text-white mb-4"
                :class="{ 'animate-fade-in-up': inView }">
                Complete Hosting Solutions
            </h2>
            <p class="text-xl text-gray-400"
               :class="{ 'animate-fade-in-up': inView }"
               style="animation-delay: 0.1s;">
                From basic shared hosting to powerful dedicated servers - we have the perfect solution for every need
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <!-- Shared Hosting -->
            <div class="bg-gray-800 p-6 rounded-xl border border-gray-700 hover:border-green-500 transition-all duration-300 transform hover:-translate-y-2 hover:shadow-2xl group"
                 :class="{ 'animate-fade-in-up': inView }"
                 style="animation-delay: 0.1s;">
                <div class="w-14 h-14 bg-gradient-to-br from-green-500 to-green-600 rounded-lg flex items-center justify-center mb-4 group-hover:scale-110 transition-transform duration-300">
                    <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 15a4 4 0 004 4h9a5 5 0 10-.1-9.999 5.002 5.002 0 10-9.78 2.096A4.001 4.001 0 003 15z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-white mb-2">Shared Hosting</h3>
                <p class="text-gray-400 text-sm mb-4">Perfect for personal websites and small businesses. Affordable and easy to use.</p>
                <ul class="space-y-2 mb-4">
                    <li class="flex items-center text-sm text-gray-300">
                        <svg class="w-4 h-4 text-green-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span>cPanel Control</span>
                    </li>
                    <li class="flex items-center text-sm text-gray-300">
                        <svg class="w-4 h-4 text-green-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span>Free SSL</span>
                    </li>
                    <li class="flex items-center text-sm text-gray-300">
                        <svg class="w-4 h-4 text-green-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span>From $4.99/mo</span>
                    </li>
                </ul>
                <a href="{{ route('order.hosting') }}" class="block text-center py-2 text-green-400 hover:text-green-300 font-semibold transition">
                    Learn More →
                </a>
            </div>
            
            <!-- WordPress Hosting -->
            <div class="bg-gray-800 p-6 rounded-xl border border-gray-700 hover:border-blue-500 transition-all duration-300 transform hover:-translate-y-2 hover:shadow-2xl group"
                 :class="{ 'animate-fade-in-up': inView }"
                 style="animation-delay: 0.2s;">
                <div class="w-14 h-14 bg-gradient-to-br from-blue-500 to-blue-600 rounded-lg flex items-center justify-center mb-4 group-hover:scale-110 transition-transform duration-300">
                    <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-white mb-2">WordPress Hosting</h3>
                <p class="text-gray-400 text-sm mb-4">Optimized for WordPress with automatic updates and enhanced security.</p>
                <ul class="space-y-2 mb-4">
                    <li class="flex items-center text-sm text-gray-300">
                        <svg class="w-4 h-4 text-blue-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span>WP Optimized</span>
                    </li>
                    <li class="flex items-center text-sm text-gray-300">
                        <svg class="w-4 h-4 text-blue-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span>Auto Updates</span>
                    </li>
                    <li class="flex items-center text-sm text-gray-300">
                        <svg class="w-4 h-4 text-blue-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span>From $6.99/mo</span>
                    </li>
                </ul>
                <a href="{{ route('order.hosting') }}" class="block text-center py-2 text-blue-400 hover:text-blue-300 font-semibold transition">
                    Learn More →
                </a>
            </div>
            
            <!-- Reseller Hosting -->
            <div class="bg-gray-800 p-6 rounded-xl border border-gray-700 hover:border-purple-500 transition-all duration-300 transform hover:-translate-y-2 hover:shadow-2xl group"
                 :class="{ 'animate-fade-in-up': inView }"
                 style="animation-delay: 0.3s;">
                <div class="w-14 h-14 bg-gradient-to-br from-purple-500 to-purple-600 rounded-lg flex items-center justify-center mb-4 group-hover:scale-110 transition-transform duration-300">
                    <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-white mb-2">Reseller Hosting</h3>
                <p class="text-gray-400 text-sm mb-4">Start your own hosting business with our white-label reseller packages.</p>
                <ul class="space-y-2 mb-4">
                    <li class="flex items-center text-sm text-gray-300">
                        <svg class="w-4 h-4 text-purple-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span>WHM Control</span>
                    </li>
                    <li class="flex items-center text-sm text-gray-300">
                        <svg class="w-4 h-4 text-purple-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span>White Label</span>
                    </li>
                    <li class="flex items-center text-sm text-gray-300">
                        <svg class="w-4 h-4 text-purple-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span>From $19.99/mo</span>
                    </li>
                </ul>
                <a href="{{ route('order.hosting') }}" class="block text-center py-2 text-purple-400 hover:text-purple-300 font-semibold transition">
                    Learn More →
                </a>
            </div>
            
            <!-- VPS Hosting -->
            <div class="bg-gray-800 p-6 rounded-xl border border-gray-700 hover:border-orange-500 transition-all duration-300 transform hover:-translate-y-2 hover:shadow-2xl group"
                 :class="{ 'animate-fade-in-up': inView }"
                 style="animation-delay: 0.4s;">
                <div class="w-14 h-14 bg-gradient-to-br from-orange-500 to-orange-600 rounded-lg flex items-center justify-center mb-4 group-hover:scale-110 transition-transform duration-300">
                    <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 3v2m6-2v2M9 19v2m6-2v2M5 9H3m2 6H3m18-6h-2m2 6h-2M7 19h10a2 2 0 002-2V7a2 2 0 00-2-2H7a2 2 0 00-2 2v10a2 2 0 002 2zM9 9h6v6H9V9z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-white mb-2">VPS Hosting</h3>
                <p class="text-gray-400 text-sm mb-4">Full root access with dedicated resources for maximum performance.</p>
                <ul class="space-y-2 mb-4">
                    <li class="flex items-center text-sm text-gray-300">
                        <svg class="w-4 h-4 text-orange-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span>Root Access</span>
                    </li>
                    <li class="flex items-center text-sm text-gray-300">
                        <svg class="w-4 h-4 text-orange-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span>SSD Storage</span>
                    </li>
                    <li class="flex items-center text-sm text-gray-300">
                        <svg class="w-4 h-4 text-orange-500 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span>From $29.99/mo</span>
                    </li>
                </ul>
                <a href="{{ route('order.vps') }}" class="block text-center py-2 text-orange-400 hover:text-orange-300 font-semibold transition">
                    Learn More →
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Testimonials Section -->
<div class="py-20 bg-gray-900" x-data="{ inView: false }" x-intersect="inView = true">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="text-4xl font-bold text-white mb-4"
                :class="{ 'animate-fade-in-up': inView }">
                Trusted by Thousands
            </h2>
            <p class="text-xl text-gray-400"
               :class="{ 'animate-fade-in-up': inView }"
               style="animation-delay: 0.1s;">
                See what our customers have to say
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div class="bg-gray-800 p-8 rounded-xl border border-gray-700 hover:border-blue-500 transition-all duration-300"
                 :class="{ 'animate-fade-in-up': inView }"
                 style="animation-delay: 0.2s;">
                <div class="flex items-center mb-4">
                    <div class="flex text-yellow-400">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                    </div>
                </div>
                <p class="text-gray-300 mb-6 leading-relaxed">"Exceptional hosting service! The speed and reliability are outstanding. Customer support is always quick to respond and very helpful."</p>
                <div class="flex items-center">
                    <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-purple-600 rounded-full flex items-center justify-center mr-4">
                        <span class="text-white font-bold text-lg">JD</span>
                    </div>
                    <div>
                        <div class="font-semibold text-white">John Doe</div>
                        <div class="text-sm text-gray-400">Web Developer</div>
                    </div>
                </div>
            </div>
            
            <div class="bg-gray-800 p-8 rounded-xl border border-gray-700 hover:border-purple-500 transition-all duration-300"
                 :class="{ 'animate-fade-in-up': inView }"
                 style="animation-delay: 0.3s;">
                <div class="flex items-center mb-4">
                    <div class="flex text-yellow-400">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                    </div>
                </div>
                <p class="text-gray-300 mb-6 leading-relaxed">"Best hosting provider I've used! The performance is incredible and the control panel is very intuitive. Highly recommended!"</p>
                <div class="flex items-center">
                    <div class="w-12 h-12 bg-gradient-to-br from-green-500 to-blue-600 rounded-full flex items-center justify-center mr-4">
                        <span class="text-white font-bold text-lg">SM</span>
                    </div>
                    <div>
                        <div class="font-semibold text-white">Sarah Mitchell</div>
                        <div class="text-sm text-gray-400">Business Owner</div>
                    </div>
                </div>
            </div>
            
            <div class="bg-gray-800 p-8 rounded-xl border border-gray-700 hover:border-green-500 transition-all duration-300"
                 :class="{ 'animate-fade-in-up': inView }"
                 style="animation-delay: 0.4s;">
                <div class="flex items-center mb-4">
                    <div class="flex text-yellow-400">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                    </div>
                </div>
                <p class="text-gray-300 mb-6 leading-relaxed">"Outstanding value for money! The features are robust and the uptime has been perfect. Migration was seamless too."</p>
                <div class="flex items-center">
                    <div class="w-12 h-12 bg-gradient-to-br from-purple-500 to-pink-600 rounded-full flex items-center justify-center mr-4">
                        <span class="text-white font-bold text-lg">MJ</span>
                    </div>
                    <div>
                        <div class="font-semibold text-white">Mike Johnson</div>
                        <div class="text-sm text-gray-400">Freelance Designer</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- News & Updates Section -->
<div class="py-20 bg-gray-900" x-data="{ inView: false }" x-intersect="inView = true">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="text-4xl font-bold text-white mb-4"
                :class="{ 'animate-fade-in-up': inView }">
                Latest News & Updates
            </h2>
            <p class="text-xl text-gray-400"
               :class="{ 'animate-fade-in-up': inView }"
               style="animation-delay: 0.1s;">
                Stay informed with the latest hosting industry news and company updates
            </p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <!-- News Article 1 -->
            <div class="bg-gray-800 rounded-xl overflow-hidden border border-gray-700 hover:border-blue-500 transition-all duration-300 transform hover:-translate-y-2 hover:shadow-2xl"
                 :class="{ 'animate-fade-in-up': inView }"
                 style="animation-delay: 0.2s;">
                <div class="h-48 bg-gradient-to-br from-blue-600 to-purple-600 flex items-center justify-center">
                    <svg class="w-20 h-20 text-white opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                    </svg>
                </div>
                <div class="p-6">
                    <div class="text-sm text-blue-400 mb-2">December 15, 2024</div>
                    <h3 class="text-xl font-bold text-white mb-3">Introducing Lightning-Fast SSD NVMe Hosting</h3>
                    <p class="text-gray-400 mb-4">Experience up to 10x faster website loading speeds with our new NVMe SSD technology. Perfect for high-traffic websites.</p>
                    <a href="#" class="inline-flex items-center text-blue-400 hover:text-blue-300 font-semibold transition">
                        Read More
                        <svg class="w-4 h-4 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                        </svg>
                    </a>
                </div>
            </div>
            
            <!-- News Article 2 -->
            <div class="bg-gray-800 rounded-xl overflow-hidden border border-gray-700 hover:border-green-500 transition-all duration-300 transform hover:-translate-y-2 hover:shadow-2xl"
                 :class="{ 'animate-fade-in-up': inView }"
                 style="animation-delay: 0.3s;">
                <div class="h-48 bg-gradient-to-br from-green-600 to-blue-600 flex items-center justify-center">
                    <svg class="w-20 h-20 text-white opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                    </svg>
                </div>
                <div class="p-6">
                    <div class="text-sm text-green-400 mb-2">December 10, 2024</div>
                    <h3 class="text-xl font-bold text-white mb-3">Enhanced Security Features Now Live</h3>
                    <p class="text-gray-400 mb-4">We've implemented advanced DDoS protection and malware scanning to keep your websites safe and secure 24/7.</p>
                    <a href="#" class="inline-flex items-center text-green-400 hover:text-green-300 font-semibold transition">
                        Read More
                        <svg class="w-4 h-4 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                        </svg>
                    </a>
                </div>
            </div>
            
            <!-- News Article 3 -->
            <div class="bg-gray-800 rounded-xl overflow-hidden border border-gray-700 hover:border-purple-500 transition-all duration-300 transform hover:-translate-y-2 hover:shadow-2xl"
                 :class="{ 'animate-fade-in-up': inView }"
                 style="animation-delay: 0.4s;">
                <div class="h-48 bg-gradient-to-br from-purple-600 to-pink-600 flex items-center justify-center">
                    <svg class="w-20 h-20 text-white opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>
                    </svg>
                </div>
                <div class="p-6">
                    <div class="text-sm text-purple-400 mb-2">December 5, 2024</div>
                    <h3 class="text-xl font-bold text-white mb-3">Free Migration Service for All Plans</h3>
                    <p class="text-gray-400 mb-4">Moving to our hosting? We'll handle your website migration completely free with zero downtime guaranteed.</p>
                    <a href="#" class="inline-flex items-center text-purple-400 hover:text-purple-300 font-semibold transition">
                        Read More
                        <svg class="w-4 h-4 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                        </svg>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Final CTA Section -->
<div class="relative bg-gradient-to-r from-blue-600 via-purple-600 to-pink-600 py-20 overflow-hidden">
    <!-- Decorative Background Elements -->
    <div class="absolute inset-0 overflow-hidden">
        <!-- Animated circles -->
        <div class="absolute top-10 left-10 w-64 h-64 bg-white rounded-full opacity-10 animate-bounce-slow"></div>
        <div class="absolute bottom-10 right-10 w-96 h-96 bg-white rounded-full opacity-5 animate-bounce-slow" style="animation-delay: 1s;"></div>
        <div class="absolute top-1/2 left-1/4 w-32 h-32 bg-yellow-300 rounded-full opacity-20 animate-bounce-slow" style="animation-delay: 2s;"></div>
        
        <!-- Geometric shapes -->
        <div class="absolute top-20 right-1/4 w-20 h-20 border-4 border-white opacity-20 rotate-45 animate-bounce-slow"></div>
        <div class="absolute bottom-20 left-1/3 w-16 h-16 border-4 border-white opacity-15 rotate-12 animate-bounce-slow" style="animation-delay: 1.5s;"></div>
        
        <!-- Grid pattern overlay -->
        <div class="absolute inset-0 bg-black opacity-10"></div>
        <div class="absolute inset-0" style="background-image: radial-gradient(circle at 2px 2px, rgba(255, 255, 255, 0.1) 1px, transparent 0); background-size: 40px 40px;"></div>
    </div>
    
    <div class="relative max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center"
         x-data="{ inView: false }" x-intersect="inView = true">
        <h2 class="text-4xl md:text-5xl font-bold text-white mb-6"
            :class="{ 'animate-fade-in-up': inView }">
            Ready to Get Started?
        </h2>
        <p class="text-xl md:text-2xl text-gray-100 mb-10"
           :class="{ 'animate-fade-in-up': inView }"
           style="animation-delay: 0.1s;">
            Join thousands of satisfied customers and take your website to the next level
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center"
             :class="{ 'animate-fade-in-up': inView }"
             style="animation-delay: 0.2s;">
            <a href="{{ route('register') }}" class="inline-block px-8 py-4 bg-white text-blue-600 font-bold text-lg rounded-lg hover:bg-gray-100 transition shadow-xl hover:shadow-2xl transform hover:-translate-y-1">
                Create Your Account
            </a>
            <a href="{{ route('client.contact') }}" class="inline-block px-8 py-4 bg-transparent border-2 border-white text-white font-bold text-lg rounded-lg hover:bg-white hover:text-blue-600 transition shadow-xl">
                Contact Sales
            </a>
        </div>
    </div>
</div>

<!-- Background Showcase Section -->
<div class="relative py-16 bg-gray-900 overflow-hidden">
    <!-- Decorative background with patterns -->
    <div class="absolute inset-0 opacity-5">
        <div class="absolute inset-0" style="background-image: url('data:image/svg+xml,%3Csvg width=&quot;60&quot; height=&quot;60&quot; viewBox=&quot;0 0 60 60&quot; xmlns=&quot;http://www.w3.org/2000/svg&quot;%3E%3Cg fill=&quot;none&quot; fill-rule=&quot;evenodd&quot;%3E%3Cg fill=&quot;%239C92AC&quot; fill-opacity=&quot;0.4&quot;%3E%3Cpath d=&quot;M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z&quot;/%3E%3C/g%3E%3C/g%3E%3C/svg%3E'); background-size: 60px 60px;"></div>
    </div>
    
    <!-- Floating illustration elements -->
    <div class="absolute inset-0 pointer-events-none">
        <!-- Server icons -->
        <div class="absolute top-10 left-10 w-16 h-16 opacity-10 animate-bounce-slow">
            <svg viewBox="0 0 24 24" fill="currentColor" class="text-blue-500">
                <path d="M20 13H4c-.55 0-1 .45-1 1v6c0 .55.45 1 1 1h16c.55 0 1-.45 1-1v-6c0-.55-.45-1-1-1zM7 19c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zM20 3H4c-.55 0-1 .45-1 1v6c0 .55.45 1 1 1h16c.55 0 1-.45 1-1V4c0-.55-.45-1-1-1zM7 9c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z"/>
            </svg>
        </div>
        
        <!-- Cloud icon -->
        <div class="absolute top-1/4 right-20 w-20 h-20 opacity-10 animate-bounce-slow" style="animation-delay: 1s;">
            <svg viewBox="0 0 24 24" fill="currentColor" class="text-purple-500">
                <path d="M19.35 10.04C18.67 6.59 15.64 4 12 4 9.11 4 6.6 5.64 5.35 8.04 2.34 8.36 0 10.91 0 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.65-4.96z"/>
            </svg>
        </div>
        
        <!-- Shield icon -->
        <div class="absolute bottom-20 left-1/4 w-16 h-16 opacity-10 animate-bounce-slow" style="animation-delay: 2s;">
            <svg viewBox="0 0 24 24" fill="currentColor" class="text-green-500">
                <path d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4zm-2 16l-4-4 1.41-1.41L10 14.17l6.59-6.59L18 9l-8 8z"/>
            </svg>
        </div>
        
        <!-- Lightning icon -->
        <div class="absolute top-1/2 right-1/4 w-12 h-12 opacity-10 animate-bounce-slow" style="animation-delay: 0.5s;">
            <svg viewBox="0 0 24 24" fill="currentColor" class="text-yellow-400">
                <path d="M7 2v11h3v9l7-12h-4l4-8z"/>
            </svg>
        </div>
        
        <!-- Globe icon -->
        <div class="absolute bottom-10 right-10 w-16 h-16 opacity-10 animate-bounce-slow" style="animation-delay: 1.5s;">
            <svg viewBox="0 0 24 24" fill="currentColor" class="text-blue-400">
                <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-1 17.93c-3.95-.49-7-3.85-7-7.93 0-.62.08-1.21.21-1.79L9 15v1c0 1.1.9 2 2 2v1.93zm6.9-2.54c-.26-.81-1-1.39-1.9-1.39h-1v-3c0-.55-.45-1-1-1H8v-2h2c.55 0 1-.45 1-1V7h2c1.1 0 2-.9 2-2v-.41c2.93 1.19 5 4.06 5 7.41 0 2.08-.8 3.97-2.1 5.39z"/>
            </svg>
        </div>
    </div>
    
    <!-- Statistics or features showcase -->
    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-2 md:grid-cols-4 gap-8 text-center">
            <div class="animate-fade-in-up" style="animation-delay: 0.1s;">
                <div class="text-4xl md:text-5xl font-bold text-blue-500 mb-2">99.9%</div>
                <div class="text-gray-400 text-sm md:text-base">Uptime Guarantee</div>
            </div>
            <div class="animate-fade-in-up" style="animation-delay: 0.2s;">
                <div class="text-4xl md:text-5xl font-bold text-purple-500 mb-2">24/7</div>
                <div class="text-gray-400 text-sm md:text-base">Expert Support</div>
            </div>
            <div class="animate-fade-in-up" style="animation-delay: 0.3s;">
                <div class="text-4xl md:text-5xl font-bold text-green-500 mb-2">50K+</div>
                <div class="text-gray-400 text-sm md:text-base">Happy Customers</div>
            </div>
            <div class="animate-fade-in-up" style="animation-delay: 0.4s;">
                <div class="text-4xl md:text-5xl font-bold text-pink-500 mb-2">15+</div>
                <div class="text-gray-400 text-sm md:text-base">Years Experience</div>
            </div>
        </div>
    </div>
</div>
@endsection
