<?php $__env->startSection('title', 'Email Settings'); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-900 p-6">
    <div class="max-w-7xl mx-auto">
        <!-- Breadcrumb -->
        <nav class="flex mb-6" aria-label="Breadcrumb">
            <ol class="inline-flex items-center space-x-1 md:space-x-3">
                <li class="inline-flex items-center">
                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="text-gray-400 hover:text-white">Admin</a>
                </li>
                <li>
                    <div class="flex items-center">
                        <svg class="w-6 h-6 text-gray-400" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path></svg>
                        <a href="<?php echo e(route('admin.settings.index')); ?>" class="ml-1 text-gray-400 hover:text-white">Settings</a>
                    </div>
                </li>
                <li aria-current="page">
                    <div class="flex items-center">
                        <svg class="w-6 h-6 text-gray-400" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path></svg>
                        <span class="ml-1 text-gray-500">Email Settings</span>
                    </div>
                </li>
            </ol>
        </nav>

        <!-- Header -->
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-white mb-2">Email Settings</h1>
            <p class="text-gray-400">Configure SMTP server, email templates, and notification settings</p>
        </div>

        <?php if(session('success')): ?>
            <div class="mb-6 p-4 bg-green-500/10 border border-green-500 text-green-400 rounded-lg flex items-center">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                </svg>
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="mb-6 p-4 bg-red-500/10 border border-red-500 text-red-400 rounded-lg flex items-center">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>

        <?php if($errors->any()): ?>
            <div class="mb-6 p-4 bg-red-500/10 border border-red-500 text-red-400 rounded-lg">
                <div class="font-semibold mb-2">Please correct the following errors:</div>
                <ul class="list-disc list-inside space-y-1">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <!-- SMTP Information Alert -->
        <div class="mb-6 p-4 bg-blue-500/10 border border-blue-500 text-blue-400 rounded-lg">
            <div class="flex items-start">
                <svg class="w-5 h-5 mr-3 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                <div>
                    <div class="font-semibold mb-1">SMTP Configuration Tips</div>
                    <ul class="text-sm space-y-1 list-disc list-inside">
                        <li>Most SMTP servers require the <strong>SMTP Username</strong> to match the <strong>From Email Address</strong></li>
                        <li>If you use different addresses, emails will be sent from the SMTP Username to avoid "Sender verify failed" errors</li>
                        <li>For cPanel/shared hosting, always use the same email address for both fields</li>
                        <li>Use the "Test Connection" button to verify your settings before saving</li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- Email Settings Form -->
        <div class="bg-gray-800 border border-gray-700 rounded-xl p-6">
            <form method="POST" action="<?php echo e(route('admin.settings.email.update')); ?>">
                <?php echo csrf_field(); ?>
                
                <!-- SMTP Configuration Section -->
                <div class="mb-8">
                    <h3 class="text-lg font-semibold text-white mb-4 flex items-center">
                        <svg class="w-5 h-5 mr-2 text-purple-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                        </svg>
                        SMTP Server Configuration
                    </h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-medium text-gray-300 mb-2">Mail Driver</label>
                            <select name="mail_mailer" class="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded-lg text-white focus:outline-none focus:border-blue-500" required>
                                <option value="smtp" <?php echo e(($settings['mail_mailer'] ?? 'smtp') === 'smtp' ? 'selected' : ''); ?>>SMTP</option>
                                <option value="sendmail" <?php echo e(($settings['mail_mailer'] ?? 'smtp') === 'sendmail' ? 'selected' : ''); ?>>Sendmail</option>
                                <option value="log" <?php echo e(($settings['mail_mailer'] ?? 'smtp') === 'log' ? 'selected' : ''); ?>>Log (Testing)</option>
                            </select>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-300 mb-2">SMTP Host <span class="text-red-400">*</span></label>
                            <input type="text" name="mail_host" value="<?php echo e($settings['mail_host'] ?? ''); ?>" 
                                   class="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded-lg text-white focus:outline-none focus:border-blue-500"
                                   placeholder="smtp.gmail.com" required>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-300 mb-2">SMTP Port <span class="text-red-400">*</span></label>
                            <input type="number" name="mail_port" value="<?php echo e($settings['mail_port'] ?? '587'); ?>" 
                                   class="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded-lg text-white focus:outline-none focus:border-blue-500"
                                   placeholder="587" required>
                            <p class="text-sm text-gray-400 mt-1">Common ports: 25 (plain), 587 (TLS), 465 (SSL)</p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-300 mb-2">Encryption</label>
                            <select name="mail_encryption" class="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded-lg text-white focus:outline-none focus:border-blue-500">
                                <option value="">None</option>
                                <option value="tls" <?php echo e(($settings['mail_encryption'] ?? 'tls') === 'tls' ? 'selected' : ''); ?>>TLS</option>
                                <option value="ssl" <?php echo e(($settings['mail_encryption'] ?? 'tls') === 'ssl' ? 'selected' : ''); ?>>SSL</option>
                            </select>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-300 mb-2">SMTP Username</label>
                            <input type="text" name="mail_username" value="<?php echo e($settings['mail_username'] ?? ''); ?>" 
                                   class="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded-lg text-white focus:outline-none focus:border-blue-500"
                                   placeholder="your-email@example.com">
                            <p class="text-sm text-yellow-400 mt-1">⚠️ Important: Most SMTP servers require this to match the From Email Address below</p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-300 mb-2">SMTP Password</label>
                            <input type="password" name="mail_password" value="<?php echo e($settings['mail_password'] ?? ''); ?>" 
                                   class="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded-lg text-white focus:outline-none focus:border-blue-500"
                                   placeholder="••••••••">
                            <p class="text-sm text-gray-400 mt-1">Leave blank to keep existing password</p>
                        </div>
                    </div>
                </div>

                <!-- From Address Section -->
                <div class="mb-8">
                    <h3 class="text-lg font-semibold text-white mb-4 flex items-center">
                        <svg class="w-5 h-5 mr-2 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 12a4 4 0 10-8 0 4 4 0 008 0zm0 0v1.5a2.5 2.5 0 005 0V12a9 9 0 10-9 9m4.5-1.206a8.959 8.959 0 01-4.5 1.207"></path>
                        </svg>
                        Email From Details
                    </h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-medium text-gray-300 mb-2">From Name <span class="text-red-400">*</span></label>
                            <input type="text" name="mail_from_name" value="<?php echo e($settings['mail_from_name'] ?? config('app.name')); ?>" 
                                   class="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded-lg text-white focus:outline-none focus:border-blue-500"
                                   placeholder="BillingCS" required>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-300 mb-2">From Email Address <span class="text-red-400">*</span></label>
                            <input type="email" name="mail_from_address" value="<?php echo e($settings['mail_from_address'] ?? ''); ?>" 
                                   class="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded-lg text-white focus:outline-none focus:border-blue-500"
                                   placeholder="noreply@example.com" required>
                            <p class="text-sm text-yellow-400 mt-1">⚠️ For best compatibility, use the same email as SMTP Username to avoid sender verification errors</p>
                        </div>
                    </div>
                </div>

                <!-- Test Email Section -->
                <div class="mb-8">
                    <h3 class="text-lg font-semibold text-white mb-4 flex items-center">
                        <svg class="w-5 h-5 mr-2 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        Test Email Configuration
                    </h3>
                    <div class="grid grid-cols-1 gap-6">
                        <div>
                            <label class="block text-sm font-medium text-gray-300 mb-2">Test Recipient Email</label>
                            <input type="email" name="test_email_recipient" value="<?php echo e($settings['test_email_recipient'] ?? ''); ?>" 
                                   class="w-full px-4 py-2 bg-gray-700 border border-gray-600 rounded-lg text-white focus:outline-none focus:border-blue-500"
                                   placeholder="Leave blank to test with site email">
                            <p class="text-sm text-gray-400 mt-1">Optional: Specify an email address to receive test emails. If left blank, test emails will be sent to the site email (SMTP Username).</p>
                        </div>
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="flex items-center justify-between">
                    <a href="<?php echo e(route('admin.settings.index')); ?>" 
                       class="px-6 py-2 bg-gray-700 text-white rounded-lg hover:bg-gray-600 transition">
                        Back to Settings
                    </a>
                    <div class="flex space-x-4">
                        <button type="button" id="testEmailBtn"
                                class="px-6 py-2 bg-yellow-600 text-white rounded-lg hover:bg-yellow-700 transition flex items-center">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            Test Connection
                        </button>
                        <button type="submit" 
                                class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition flex items-center">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                            </svg>
                            Save Settings
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.getElementById('testEmailBtn').addEventListener('click', function() {
    const btn = this;
    const originalText = btn.innerHTML;
    
    // Disable button and show loading state
    btn.disabled = true;
    btn.innerHTML = '<svg class="w-5 h-5 mr-2 animate-spin" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path></svg> Testing...';
    
    // Get form data
    const formData = new FormData(btn.closest('form'));
    
    // Send test request
    fetch('<?php echo e(route("admin.settings.email.test")); ?>', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            'Accept': 'application/json',
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        btn.disabled = false;
        btn.innerHTML = originalText;
        
        if (data.success) {
            alert('✅ Success! Test email sent successfully. Check your inbox.');
        } else {
            alert('❌ Error: ' + (data.message || 'Failed to send test email'));
        }
    })
    .catch(error => {
        btn.disabled = false;
        btn.innerHTML = originalText;
        alert('❌ Error: Could not test email connection. Please check your settings.');
    });
});
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\HP\OneDrive\Desktop\Script\Personal_Project\BillingSystem\BillingCS-main\resources\views/admin/settings/categories/email.blade.php ENDPATH**/ ?>