# Project: Gamer Challenge & Tournament Platform (BattleMania Advanced)

We are building a Laravel 11 web application where gamers can:
- Post and accept **1v1 challenges** with wager money (escrow system).
- Create and join **tournaments** (knockout, round robin).
- Earn **XP, levels, and badges** based on activity and wins.
- Use a **wallet system** with deposits, withdrawals, and transaction history.
- Handle disputes with **proof uploads** and **admin decisions**.
- Unlock tournament-hosting privileges when they reach higher levels.

---

## Tech Stack
- **Backend:** Laravel 11 (PHP 8.3), Eloquent ORM, Sanctum for SPA/API tokens.
- **Frontend:** Blade (with TailwindCSS, dark CODM theme). Optional Vue/React later.
- **Database:** MySQL or PostgreSQL.
- **Payments:** Paystack/Flutterwave (NGN).
- **Storage:** Local/S3 for screenshots and tournament media.
- **Notifications:** Laravel Mail + In-app + Broadcast (Pusher/Redis).

---

## Features to Implement

### 1. Authentication & Profiles
- Register/login/logout with email & username.
- Profiles show XP, level, wallet balance, win/loss record, badges.
- Middleware to restrict features by level.

### 2. Wallet & Escrow
- Users deposit and withdraw money (via Paystack/Flutterwave).
- Wager money locked in escrow when a challenge is accepted.
- Funds released to winner after result confirmation or admin resolution.
- Platform takes a commission (configurable %).

### 3. Challenges (1v1)
- Create a challenge: choose game, wager amount, custom rules.
- Challenge is listed as **open** until accepted.
- Another user accepts → escrow funds from both sides.
- Both players upload proof (screenshot).
- If both confirm → auto payout to winner.
- If dispute → lock until admin decides.

### 4. Tournaments
- Only higher-level users (Level 3+) can host tournaments.
- Tournament setup: name, game, format (knockout/round robin), entry fee, livestream link.
- System generates brackets automatically.
- Players join by paying entry fee → added to bracket.
- Matches progress automatically as winners are reported.
- Prize pool distributed automatically to winners.

### 5. Levels & Badges
- XP system:
  - +10 XP per match played
  - +20 XP per match won
  - +15 XP per tournament joined
  - Bonus XP for no-dispute streaks
- Levels unlock features:
  - L1: join matches
  - L2: create challenges
  - L3: host free tournaments
  - L4+: host paid tournaments (requires KYC & admin approval)
- Badges (e.g. Top Winner, 10 Matches Played, Verified Organizer).

### 6. Leaderboards
- Rankings by XP, wins, and total earnings.
- Daily, weekly, and all-time leaderboards.

### 7. Disputes
- Players can raise disputes if results differ.
- Attach proof (screenshot, video link).
- Admin panel for reviewing disputes and awarding outcome.
- Strike system for abuse (false disputes, cheating).

### 8. Admin Panel
- Manage users, wallets, disputes, tournaments, and challenges.
- Ban cheaters, approve tournament organizer applications.
- View analytics (total matches, wagers, revenue).
- Configure fees, XP rules, and level requirements.

---

## Database Schema (Migrations Required)

**users**
- id, username, email, password, avatar_url
- xp, level, wallet_balance, locked_balance
- kyc_status (none, pending, verified)
- agreement_rate, strike_count
- is_organizer, status (active/banned)

**games**
- id, name, slug, platform (mobile/pc/console)

**challenges**
- id, creator_id, accepter_id, game_id
- wager_amount, best_of, rules_text
- status (open, accepted, completed, disputed)
- result (creator_win, accepter_win, none)

**match_proofs**
- id, challenge_id, user_id, file_url, notes

**disputes**
- id, challenge_id, opened_by, reason
- status (open, resolved), resolution, admin_id

**tournaments**
- id, host_id, game_id, type, title, description
- entry_fee, prize_pool, livestream_link
- status (upcoming, ongoing, completed)
- bracket_json

**tournament_participants**
- id, tournament_id, user_id, seed, result

**tournament_matches**
- id, tournament_id, round
- player_a_id, player_b_id, result, dispute_id

**wallet_transactions**
- id, user_id, type (deposit, withdraw, wager, prize, fee, refund)
- amount, status, reference, provider

**levels**
- id, name, min_xp, min_matches, min_agreement_rate
- requires_kyc, can_create_challenges, can_host_free_tournaments, can_host_paid_tournaments

**badges**
- id, name, description, icon

**user_badges**
- id, user_id, badge_id

**notifications**
- id, user_id, type, title, body, data, read_at

---

## Routes to Generate (API + Web)
### Public
- GET /challenges (list open challenges)
- GET /tournaments (list tournaments)
- GET /leaderboards

### Authenticated
- POST /challenges (create)
- POST /challenges/{id}/accept
- POST /challenges/{id}/submit-proof
- POST /challenges/{id}/agree-result
- POST /challenges/{id}/dispute
- POST /tournaments (create)
- POST /tournaments/{id}/join
- POST /tournaments/{id}/report-match
- GET /wallet
- POST /wallet/deposit
- POST /wallet/withdraw

### Admin
- GET /admin/disputes
- POST /admin/disputes/{id}/decide
- POST /admin/users/{id}/ban
- GET /admin/dashboard (analytics)

---

## Instructions for Copilot
1. Generate Laravel migrations, models, factories, seeders for all schema above.
2. Generate Eloquent relationships (User ↔ Challenges, Tournament ↔ Participants).
3. Create Controllers for:
   - Auth, Wallet, Challenges, Tournaments, Leaderboards, Disputes, Admin.
4. Create middleware for:
   - CheckLevel (restrict actions by level).
   - Escrow logic for wagers.
5. Use Events & Listeners for:
   - Challenge accepted, dispute opened, tournament created.
   - Notifications + email sending.
6. Generate Blade views with TailwindCSS (dark gaming theme).
   - Home (featured tournaments, open challenges, leaderboards).
   - Challenges (list, create, accept, submit proof).
   - Tournaments (brackets, join, livestream embed).
   - Profile (stats, XP bar, badges, wallet).
   - Admin dashboard.
7. Implement wallet service class for:
   - Locking escrow funds on accept.
   - Releasing funds to winner.
   - Taking commission fee.
8. Add XP and Level system:
   - Increment XP when users complete actions.
   - Auto-level up when thresholds reached.
9. Add Badge awarding system:
   - Check conditions (matches, wins, tournaments) → assign badges.
10. Make all code modular, clean, and well-commented.

---

## Theme/Style
- TailwindCSS with dark Call of Duty style.
- Use gaming fonts and highlight stats in bold numbers.
- Profiles should look like game cards (XP bar, badges, rank).
