# 🎮 BattleMania - Gaming Challenge Platform

A complete Laravel 11 gaming platform for CODM-style wagering, tournaments, and competitions. Built with a dark, gaming-inspired UI and comprehensive backend functionality.

## 🚀 Features

### 🎯 Core Gaming Features
- **Challenge System**: Create and accept 1v1 gaming challenges with real money wagers
- **Tournament Management**: Host and participate in tournaments with bracket generation
- **Leaderboards**: Rankings based on XP, level, and win statistics
- **Level Progression**: Experience points system with level-based permissions
- **Badge System**: Achievement tracking and rewards

### 💰 Financial System
- **Integrated Wallet**: Deposit, withdraw, and manage gaming funds
- **Escrow System**: Secure fund holding during challenges
- **Commission Tracking**: 5% platform fee on all transactions
- **Transaction History**: Complete audit trail of all financial activities

### 🛡️ Admin Panel
- **User Management**: View, ban, and promote users to admin
- **Dispute Resolution**: Handle challenge disputes with evidence review
- **Platform Analytics**: Real-time statistics and insights
- **Content Moderation**: Monitor and manage platform activity

### 🔐 Security & Authentication
- **Laravel Sanctum**: API authentication for mobile apps
- **Role-based Access**: Level and KYC-based permissions
- **Rate Limiting**: Protection against abuse
- **Input Validation**: Comprehensive security measures

## 📱 Supported Games

- Call of Duty Mobile
- PUBG Mobile
- FIFA Mobile
- Free Fire
- Fortnite
- Valorant
- League of Legends
- FIFA 24

## 🛠️ Technical Stack

- **Backend**: Laravel 11 (PHP 8.3+)
- **Database**: SQLite (development) / MySQL (production)
- **Frontend**: Blade templates with custom CODM-style CSS
- **Authentication**: Laravel Breeze with custom UI
- **API**: RESTful API with Laravel Sanctum
- **File Storage**: Local filesystem (configurable to AWS S3)

## 📋 Installation

### Prerequisites

- PHP 8.3 or higher
- Composer
- Node.js & NPM (for asset compilation)
- MySQL (for production)

### Development Setup

1. **Clone the repository**
   ```bash
   git clone https://github.com/your-username/battlemania.git
   cd battlemania
   ```

2. **Install PHP dependencies**
   ```bash
   composer install
   ```

3. **Environment setup**
   ```bash
   cp .env.example .env
   php artisan key:generate
   ```

4. **Database setup**
   ```bash
   # For SQLite (development)
   touch database/database.sqlite
   
   # Update .env
   DB_CONNECTION=sqlite
   DB_DATABASE=/path/to/your/project/database/database.sqlite
   ```

5. **Run migrations and seed data**
   ```bash
   php artisan migrate:fresh --seed
   ```

6. **Create storage directories**
   ```bash
   mkdir -p storage/framework/{cache,sessions,views}
   chmod -R 775 storage
   ```

7. **Start development server**
   ```bash
   php artisan serve
   ```

### Production Setup

1. **Environment configuration**
   ```bash
   # Update .env for production
   APP_ENV=production
   APP_DEBUG=false
   DB_CONNECTION=mysql
   # ... other production settings
   ```

2. **Database setup**
   ```bash
   # Create MySQL database
   mysql -u root -p
   CREATE DATABASE battlemania_production;
   CREATE USER 'battlemania_user'@'localhost' IDENTIFIED BY 'secure_password';
   GRANT ALL PRIVILEGES ON battlemania_production.* TO 'battlemania_user'@'localhost';
   ```

3. **Optimize for production**
   ```bash
   composer install --no-dev --optimize-autoloader
   php artisan config:cache
   php artisan route:cache
   php artisan view:cache
   ```

## 👤 Default Accounts

After running the seeders, you'll have access to:

- **Admin Account**: admin@battlemania.com / password
- **Demo Users**: gamer1@example.com / password, player2@example.com / password

## 🎮 Usage Guide

### For Players

1. **Registration**: Create account with username and email
2. **Verification**: Complete profile and optionally verify KYC for higher limits
3. **Wallet Setup**: Deposit funds to participate in paid challenges
4. **Create Challenges**: Set up gaming matches with wager amounts
5. **Join Tournaments**: Participate in organized competitions
6. **Earn XP**: Level up by winning matches and tournaments

### For Admins

1. **Access Admin Panel**: Available in user dropdown for admin users
2. **User Management**: View user details, ban/unban accounts, grant admin privileges
3. **Dispute Resolution**: Review evidence and resolve challenge disputes
4. **Platform Monitoring**: Track statistics and platform health

## 🔧 Configuration

### Environment Variables

Key configuration options in `.env`:

```env
# Platform Settings
PLATFORM_COMMISSION_RATE=0.05
MINIMUM_WITHDRAWAL_AMOUNT=1000
MAXIMUM_WITHDRAWAL_AMOUNT=1000000

# Admin Password (for seeding)
ADMIN_PASSWORD=your_secure_password

# Payment Gateways
PAYSTACK_PUBLIC_KEY=your_paystack_public_key
PAYSTACK_SECRET_KEY=your_paystack_secret_key
```

### Level System

The platform includes a 5-tier level system:
- **Rookie** (0 XP): Can browse and view
- **Player** (50 XP): Can create challenges
- **Competitor** (200 XP): Can host free tournaments
- **Pro** (500 XP): Can host paid tournaments (requires KYC)
- **Elite** (1000 XP): Full platform access

## 🔒 Security Features

- CSRF protection on all forms
- Input validation and sanitization
- Rate limiting on authentication
- Secure session management
- SQL injection prevention
- XSS protection

## 📊 API Documentation

The platform provides a comprehensive RESTful API:

### Authentication
- `POST /api/login` - User authentication
- `POST /api/register` - User registration

### Challenges
- `GET /api/challenges` - List challenges
- `POST /api/challenges` - Create challenge
- `POST /api/challenges/{id}/accept` - Accept challenge

### Tournaments
- `GET /api/tournaments` - List tournaments
- `POST /api/tournaments` - Create tournament
- `POST /api/tournaments/{id}/join` - Join tournament

### Wallet
- `GET /api/wallet` - Get wallet balance
- `POST /api/wallet/deposit` - Process deposit
- `POST /api/wallet/withdraw` - Request withdrawal

## 🤝 Contributing

1. Fork the repository
2. Create a feature branch (`git checkout -b feature/amazing-feature`)
3. Commit your changes (`git commit -m 'Add amazing feature'`)
4. Push to the branch (`git push origin feature/amazing-feature`)
5. Open a Pull Request

## 📝 License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

## 🆘 Support

For support and questions:
- Create an issue on GitHub
- Contact: admin@battlemania.com

## 🔄 Updates

The platform is actively maintained with regular updates for:
- Security patches
- New game integrations
- Feature enhancements
- Performance optimizations

---

**Built with ❤️ for the gaming community**
