# BattleMania Advanced - Setup Guide

## Quick Start

This Laravel 11 gaming platform includes complete frontend build tools (Vite + TailwindCSS) and MySQL database setup.

### Prerequisites

- PHP 8.2+
- Node.js 18+
- MySQL 8.0+ (recommended) or compatible database
- Composer

### Installation Steps

1. **Clone the repository**
```bash
git clone <repository-url>
cd Agamec
```

2. **Install PHP dependencies**
```bash
composer install
```

3. **Install frontend dependencies**
```bash
npm install
```

4. **Build frontend assets**
```bash
npm run build
```

5. **Configure environment**
```bash
cp .env.example .env
php artisan key:generate
```

6. **Set up database**
   - Create a MySQL database
   - Update `.env` with your database credentials:
   ```env
   DB_CONNECTION=mysql
   DB_HOST=127.0.0.1
   DB_PORT=3306
   DB_DATABASE=your_database_name
   DB_USERNAME=your_username
   DB_PASSWORD=your_password
   ```

7. **Run migrations**
```bash
php artisan migrate --seed
```

8. **Start the application**
```bash
php artisan serve
```

## Frontend Build System

### Development
- `npm run dev` - Start Vite development server with hot reload
- `npm run watch` - Build and watch for changes

### Production
- `npm run build` - Build optimized assets for production

## Database

### MySQL Schema
The complete MySQL schema is available in `schema.sql` which includes:
- User management with XP/Level system
- Gaming challenges and tournaments
- Wallet and transaction system
- Notification system
- Social features (friends)
- Content management

### Migrations
All Laravel migrations are present and tested:
- 28 migration files covering the complete schema
- Foreign key relationships properly configured
- Indexes for performance optimization

## TailwindCSS Configuration

The project includes a gaming-themed TailwindCSS configuration with:
- Custom color palette (Call of Duty style dark theme)
- Gaming-specific utility classes
- Animation keyframes for XP bars and effects
- Custom gaming fonts and shadows

## Technology Stack

- **Backend:** Laravel 11, PHP 8.2+, MySQL
- **Frontend:** Blade templates, TailwindCSS, Alpine.js, Vite
- **Build Tools:** Vite, PostCSS, Autoprefixer
- **Authentication:** Laravel Sanctum
- **Styling:** TailwindCSS with gaming theme

## Key Features

- Complete user management with XP and leveling system
- 1v1 gaming challenges with wagering
- Tournament system (knockout/round-robin)
- Wallet system with deposits/withdrawals
- Social features (friends, notifications)
- Admin dashboard
- Mobile-responsive gaming UI

## Development Notes

- Default database connection is set to MySQL
- Frontend assets are compiled with Vite
- Gaming-themed dark UI with green accents
- Alpine.js for interactive components
- Responsive design for mobile gaming

## Troubleshooting

1. **Build errors:** Ensure Node.js 18+ is installed
2. **Migration errors:** Check database connection and permissions
3. **CSS not loading:** Run `npm run build` to compile assets
4. **Permission errors:** Check storage/ and bootstrap/cache/ permissions