<?php

namespace App\Console\Commands;

use App\Services\RoleManagementService;
use Illuminate\Console\Command;

class PromoteUsersBasedOnLevel extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'users:promote-by-level';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Promote users to Premium role based on their level progression';

    /**
     * Execute the console command.
     */
    public function handle(RoleManagementService $roleService)
    {
        $this->info('Checking users for role promotions...');
        
        $promoted = $roleService->checkAndPromoteUsers();
        
        if ($promoted > 0) {
            $this->info("Successfully promoted {$promoted} users to Premium role.");
        } else {
            $this->info('No users were eligible for promotion.');
        }

        // Show role statistics
        $stats = $roleService->getRoleStatistics();
        $this->info('Current role distribution:');
        
        foreach ($stats as $role => $data) {
            $this->line("  {$data['name']}: {$data['count']} users");
        }

        return 0;
    }
}
