<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Challenge;
use App\Models\Dispute;
use App\Models\Tournament;
use App\Models\User;
use App\Models\WalletTransaction;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    /**
     * Display the admin dashboard.
     */
    public function index()
    {
        $stats = [
            'total_users' => User::count(),
            'active_users' => User::where('status', 'active')->count(),
            'banned_users' => User::where('status', 'banned')->count(),
            'total_challenges' => Challenge::count(),
            'open_challenges' => Challenge::where('status', 'open')->count(),
            'disputed_challenges' => Challenge::where('status', 'disputed')->count(),
            'total_tournaments' => Tournament::count(),
            'ongoing_tournaments' => Tournament::where('status', 'ongoing')->count(),
            'open_disputes' => Dispute::where('status', 'open')->count(),
            'total_transactions' => WalletTransaction::sum('amount'),
            'pending_transactions' => WalletTransaction::where('status', 'pending')->count(),
        ];

        $recentDisputes = Dispute::with(['challenge.creator', 'challenge.accepter', 'openedBy'])
            ->where('status', 'open')
            ->latest()
            ->limit(10)
            ->get();

        $recentUsers = User::latest()->limit(10)->get();

        return view('admin.dashboard', compact('stats', 'recentDisputes', 'recentUsers'));
    }
}