<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CreatorRequestController extends Controller
{
    /**
     * Show the Creator request form.
     */
    public function index()
    {
        $user = Auth::user();
        
        if (!$user->canRequestCreatorStatus()) {
            return redirect()->back()->with('error', 'You cannot request Creator status at this time.');
        }

        return view('creator-request.index', compact('user'));
    }

    /**
     * Store a Creator request.
     */
    public function store(Request $request)
    {
        $user = Auth::user();
        
        if (!$user->canRequestCreatorStatus()) {
            return redirect()->back()->with('error', 'You cannot request Creator status at this time.');
        }

        $request->validate([
            'reason' => 'required|string|min:50|max:1000',
        ]);

        $success = $user->requestCreatorStatus($request->reason);

        if ($success) {
            return redirect()->route('dashboard')
                ->with('success', 'Your Creator request has been submitted and is pending admin approval.');
        }

        return redirect()->back()->with('error', 'Unable to submit Creator request. Please try again.');
    }

    /**
     * Show Creator request status.
     */
    public function status()
    {
        $user = Auth::user();
        
        return view('creator-request.status', compact('user'));
    }
}
