<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class StaticPageController extends Controller
{
    /**
     * About Us page
     */
    public function aboutUs()
    {
        return view('static.about-us');
    }

    /**
     * Contact Us page
     */
    public function contactUs()
    {
        return view('static.contact-us');
    }

    /**
     * Privacy Policy page
     */
    public function privacyPolicy()
    {
        return view('static.privacy-policy');
    }

    /**
     * Terms of Service page
     */
    public function termsOfService()
    {
        return view('static.terms-of-service');
    }

    /**
     * FAQ page
     */
    public function faq()
    {
        return view('static.faq');
    }

    /**
     * Handle contact form submission
     */
    public function submitContactForm(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'subject' => 'required|string|max:255',
            'message' => 'required|string|max:2000',
        ]);

        // Here you would typically send an email to admins
        // For now, just return success message
        
        return back()->with('success', 'Thank you for your message! We will get back to you soon.');
    }
}
