<?php

namespace App\Http\View\Composers;

use App\Models\User;
use App\Models\Challenge;
use Illuminate\View\View;
use Illuminate\Support\Facades\Cache;

class AdminStatsComposer
{
    /**
     * Bind data to the view.
     */
    public function compose(View $view): void
    {
        $stats = Cache::remember('admin_header_stats', 60, function () {
            return [
                'total_users' => User::count(),
                'active_challenges' => Challenge::where('status', 'active')->count(),
            ];
        });

        $view->with('adminHeaderStats', $stats);
    }
}