<?php

namespace App\Http\View\Composers;

use App\Models\PlatformSetting;
use Illuminate\View\View;
use Illuminate\Support\Facades\Cache;

class PlatformSettingsComposer
{
    /**
     * Bind platform settings data to the view.
     */
    public function compose(View $view): void
    {
        $platformSettings = Cache::remember('platform_settings_global', 300, function () {
            return [
                'platform_name' => PlatformSetting::get('platform_name', config('app.name', 'Agamec')),
                'platform_description' => PlatformSetting::get('platform_description', 'The ultimate gaming challenge platform'),
                'platform_logo' => PlatformSetting::get('platform_logo', null),
                'support_email' => PlatformSetting::get('support_email', 'support@agamec.com'),
                'contact_phone' => PlatformSetting::get('contact_phone', ''),
                'currency' => PlatformSetting::get('currency', '₦'),
            ];
        });

        $view->with('platformSettings', $platformSettings);
    }
}