<?php

namespace App\Listeners;

use App\Events\UserLeveledUp;
use App\Models\Notification;

class SendLevelUpNotification
{
    /**
     * Handle the event.
     */
    public function handle(UserLeveledUp $event): void
    {
        $user = $event->user;
        $newLevel = $event->newLevel;
        
        Notification::create([
            'user_id' => $user->id,
            'type' => 'level_up',
            'title' => 'Level Up!',
            'body' => "Congratulations! You've reached {$newLevel->name}. New features may be unlocked!",
            'data' => [
                'new_level_id' => $newLevel->id,
                'new_level_name' => $newLevel->name,
                'new_xp' => $user->xp,
            ],
        ]);
    }
}