<?php

namespace App\Listeners;

use App\Events\TournamentCreated;
use App\Models\Notification;
use App\Models\User;

class SendTournamentCreatedNotifications
{
    /**
     * Handle the event.
     */
    public function handle(TournamentCreated $event): void
    {
        $tournament = $event->tournament;
        
        // Notify all active users about the new tournament
        // In a real app, you might want to be more selective or use queues
        $users = User::where('status', 'active')
                    ->where('id', '!=', $tournament->host_id)
                    ->limit(100) // Limit to prevent spam
                    ->get();

        foreach ($users as $user) {
            Notification::create([
                'user_id' => $user->id,
                'type' => 'tournament_created',
                'title' => 'New Tournament Available!',
                'body' => "Join '{$tournament->title}' tournament for {$tournament->game->name}. Entry fee: ₦{$tournament->entry_fee}",
                'data' => [
                    'tournament_id' => $tournament->id,
                    'tournament_title' => $tournament->title,
                    'entry_fee' => $tournament->entry_fee,
                ],
            ]);
        }
    }
}