<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Level extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'min_xp',
        'min_matches',
        'min_games_played',
        'min_agreement_rate',
        'requires_kyc',
        'can_create_challenges',
        'can_host_free_tournaments',
        'can_host_paid_tournaments',
        'max_wager_amount',
    ];

    protected $casts = [
        'min_agreement_rate' => 'decimal:2',
        'max_wager_amount' => 'decimal:2',
        'requires_kyc' => 'boolean',
        'can_create_challenges' => 'boolean',
        'can_host_free_tournaments' => 'boolean',
        'can_host_paid_tournaments' => 'boolean',
    ];

    /**
     * Get users at this level
     */
    public function users(): BelongsToMany
    {
        return $this->belongsToMany(User::class)->wherePivot('level', $this->id);
    }
}