<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class MatchProof extends Model
{
    use HasFactory;

    protected $fillable = [
        'challenge_id',
        'user_id',
        'file_url',
        'notes',
    ];

    /**
     * The challenge this proof belongs to
     */
    public function challenge(): BelongsTo
    {
        return $this->belongsTo(Challenge::class);
    }

    /**
     * The user who uploaded this proof
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}